# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterGovernanceAssignmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_governance_assignments_list(self, resource_group):
        response = self.client.governance_assignments.list(
            scope="str",
            assessment_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_governance_assignments_get(self, resource_group):
        response = await self.client.governance_assignments.get(
            scope="str",
            assessment_name="str",
            assignment_key="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_governance_assignments_create_or_update(self, resource_group):
        response = await self.client.governance_assignments.create_or_update(
            scope="str",
            assessment_name="str",
            assignment_key="str",
            governance_assignment={
                "additionalData": {"ticketLink": "str", "ticketNumber": 0, "ticketStatus": "str"},
                "governanceEmailNotification": {
                    "disableManagerEmailNotification": bool,
                    "disableOwnerEmailNotification": bool,
                },
                "id": "str",
                "isGracePeriod": bool,
                "name": "str",
                "owner": "str",
                "remediationDueDate": "2020-02-20 00:00:00",
                "remediationEta": {"eta": "2020-02-20 00:00:00", "justification": "str"},
                "type": "str",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_governance_assignments_delete(self, resource_group):
        response = await self.client.governance_assignments.delete(
            scope="str",
            assessment_name="str",
            assignment_key="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
