# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AsyncOperationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The async operation state."""

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DaysOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DaysOfWeek."""

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"


class DirectoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The directory type."""

    ACTIVE_DIRECTORY = "ActiveDirectory"


class FilterMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The filtering mode. Effectively this can enabling or disabling the VM sizes in a particular
    set.
    """

    EXCLUDE = "Exclude"
    INCLUDE = "Include"
    RECOMMEND = "Recommend"
    DEFAULT = "Default"


class HDInsightClusterProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state, which only appears in the response."""

    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    DELETING = "Deleting"


class JsonWebKeyEncryptionAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Algorithm identifier for encryption, default RSA-OAEP."""

    RSA_OAEP = "RSA-OAEP"
    RSA_OAEP256 = "RSA-OAEP-256"
    RSA1_5 = "RSA1_5"


class OSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of operating system."""

    WINDOWS = "Windows"
    LINUX = "Linux"


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state, which only appears in the response."""

    IN_PROGRESS = "InProgress"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    DELETING = "Deleting"


class PrivateIPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The method that private IP address is allocated."""

    DYNAMIC = "dynamic"
    STATIC = "static"


class PrivateLink(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether or not private link is enabled."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class PrivateLinkConfigurationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private link configuration provisioning state, which only appears in the response."""

    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    DELETING = "Deleting"


class PrivateLinkServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The concrete private link service connection."""

    APPROVED = "Approved"
    REJECTED = "Rejected"
    PENDING = "Pending"
    REMOVED = "Removed"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class ResourceProviderConnection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The direction for the resource provider connection."""

    INBOUND = "Inbound"
    OUTBOUND = "Outbound"


class RoleName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RoleName."""

    WORKERNODE = "workernode"


class Tier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cluster tier."""

    STANDARD = "Standard"
    PREMIUM = "Premium"
