# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import SecurityInsightsConfiguration
from .operations import Operations
from .operations import AlertRulesOperations
from .operations import ActionsOperations
from .operations import AlertRuleTemplatesOperations
from .operations import BookmarksOperations
from .operations import DataConnectorsOperations
from .operations import IncidentsOperations
from .operations import IncidentCommentsOperations
from .. import models


class SecurityInsights(object):
    """API spec for Microsoft.SecurityInsights (Azure Security Insights) resource provider.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.securityinsight.aio.operations.Operations
    :ivar alert_rules: AlertRulesOperations operations
    :vartype alert_rules: azure.mgmt.securityinsight.aio.operations.AlertRulesOperations
    :ivar actions: ActionsOperations operations
    :vartype actions: azure.mgmt.securityinsight.aio.operations.ActionsOperations
    :ivar alert_rule_templates: AlertRuleTemplatesOperations operations
    :vartype alert_rule_templates: azure.mgmt.securityinsight.aio.operations.AlertRuleTemplatesOperations
    :ivar bookmarks: BookmarksOperations operations
    :vartype bookmarks: azure.mgmt.securityinsight.aio.operations.BookmarksOperations
    :ivar data_connectors: DataConnectorsOperations operations
    :vartype data_connectors: azure.mgmt.securityinsight.aio.operations.DataConnectorsOperations
    :ivar incidents: IncidentsOperations operations
    :vartype incidents: azure.mgmt.securityinsight.aio.operations.IncidentsOperations
    :ivar incident_comments: IncidentCommentsOperations operations
    :vartype incident_comments: azure.mgmt.securityinsight.aio.operations.IncidentCommentsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = SecurityInsightsConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.alert_rules = AlertRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.actions = ActionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.alert_rule_templates = AlertRuleTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.bookmarks = BookmarksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.data_connectors = DataConnectorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.incidents = IncidentsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.incident_comments = IncidentCommentsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "SecurityInsights":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
