/*
 * Copyright 2008 Sony Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the names of the copyright holders nor the names of their
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "e_cell.h"
#include "e_cell_err.h"

#include "mars_runtime.h"

uint64_t cell_queue_create(spe_task_t *task, int elm_size, int depth, int from_spe_to_ppe)
	{
	int ret;
	uint64_t q;

	DPRINTF("\n");

	ret = mars_task_queue_create(task->mars, &q,
		elm_size, depth,
		from_spe_to_ppe ?  MARS_TASK_QUEUE_MPU_TO_HOST : MARS_TASK_QUEUE_HOST_TO_MPU);
	if (ret != MARS_SUCCESS)
		{
		CELLerr(CELL_F_CELL_QUEUE_CREATE, CELL_R_QUEUE_INITIALIZATION_FAILED);
		return 0;
		}

	return q;
	}

void cell_queue_destroy(uint64_t q)
	{
	DPRINTF("\n");

	mars_task_queue_destroy(q);
	}

int cell_queue_push(uint64_t q, const void *buffer)
	{
	DPRINTF("\n");

	return (mars_task_queue_push(q, buffer) == MARS_SUCCESS);
	}

int cell_queue_try_push(uint64_t q, const void *buffer)
	{
	DPRINTF("\n");

	return (mars_task_queue_try_push(q, buffer) == MARS_SUCCESS);
	}

int cell_queue_pop(uint64_t q, void *buffer)
	{
	DPRINTF("\n");

	return (mars_task_queue_pop(q, buffer) == MARS_SUCCESS);
	}

int cell_queue_try_pop(uint64_t q, void *buffer)
	{
	DPRINTF("\n");

	return (mars_task_queue_try_pop(q, buffer) == MARS_SUCCESS);
	}
