/* ----------------------------------------------------------------------- *
 *   
 *   Copyright 1997 Transmeta Corporation - All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
 *   USA; either version 2 of the License, or (at your option) any later
 *   version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 * ----------------------------------------------------------------------- */

/* loadavgd.c - load average reporting daemon (UDP) */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <errno.h>

#include "rxload_inet.h"

void init_loadavg();
double get_loadavg();

char *ProgramName;

void server(port,timeout)
     char *port;
     int timeout;
{
  struct sockaddr_in  saddr;
  struct sockaddr     fromaddr;
  struct servent     *serv;
  int sockfd, addrlen;
  int socktype, typelen;
  char buffer[64];
  double loadavg;
  int inet_flag;

  /* First find out if we were spawned by inetd.  If so, we should have
     a datagram socket on stdin. */
  typelen = sizeof(int);
  if ( getsockopt(0, SOL_SOCKET, SO_TYPE, &socktype, &typelen) == 0
       /* && typelen == sizeof(int) && socktype == SOCK_DGRAM */ ) {
    inet_flag = 1;
    sockfd = 0;			/* This was easy */
    close(1);
    close(2);
  } else {
    inet_flag = 0;

    bzero((char *) &saddr, sizeof(saddr));

    if ( port ) {
      serv = getservbyname(port, "udp");
      if ( serv )
	saddr.sin_port = serv->s_port;
      else
	saddr.sin_port = htons(atoi(port));
    } else {
      serv = getservbyname(DEFAULT_SERVICE, "udp");
      if ( serv )
	saddr.sin_port = serv->s_port;
      else
	saddr.sin_port = htons(DEFAULT_PORT);
    }
    
    if ( !saddr.sin_port ) {
      fprintf(stderr, "%s: bad port\n", ProgramName);
      exit(12);
    }
    
    saddr.sin_family      = AF_INET;
    saddr.sin_addr.s_addr = htonl(INADDR_ANY);
    
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) {
      perror(ProgramName);
      exit(13);
    }
    if ( bind(sockfd, (struct sockaddr *) &saddr, sizeof(saddr)) < 0 ) {
      fprintf(stderr, "%s: cannot bind to server port\n", ProgramName);
      exit(14);
    }
  }

  while(1) {
    if ( inet_flag && timeout > 0 ) {
      struct timeval tv;
      fd_set sockset;
      
      tv.tv_sec = timeout;
      tv.tv_usec = 0;
      
      FD_ZERO(&sockset);
      FD_SET(sockfd,&sockset);
      
      if ( select(sockfd+1, &sockset, NULL, NULL, &tv) < 0 &&
	      errno == EINTR )
	continue;
      
      if ( !FD_ISSET(sockfd,&sockset) )
	break;
    }
    
    addrlen = sizeof(struct sockaddr);
    if ( recvfrom(sockfd, buffer, 64, 0, &fromaddr, &addrlen) < 0 )
      break;
   
    /* The first 8 bytes of the packet are returned in the reply;
       reserved for client matching requests with replies */

    bzero(buffer+8, 64-8);
    loadavg = get_loadavg();
    if ( loadavg >= 0.0 ) {
      sprintf(buffer+8, "%g", loadavg);
      sendto(sockfd, buffer, 64, 0, &fromaddr, addrlen);
    }
  }
  
  close(sockfd);
}


int main(argc,argv)
     int argc;
     char *argv[];
{
  char *port = NULL;
  int timeout = 900;
  int i;

  ProgramName = argv[0];

  for ( i = 1 ; i < argc ; i++ ) {
    if ( !strcmp("-port", argv[i]) && i != argc-1 ) {
      port = argv[++i];
    } else if ( !strcmp("-timeout", argv[i]) && i != argc-1 ) {
      timeout = atoi(argv[++i]);
    } else {
      fprintf(stderr, "Usage: %s [-port port] [-timeout timeout]\n", argv[0]);
      exit(15);
    }
  }

  init_loadavg();
  server(port,timeout);
  exit(0);
}
