/* $Id: worldwin.c,v 1.3 90/05/09 22:11:15 pturner Exp Locker: pturner $
 *
 * World/view popup
 *
 */

#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"

#define define_select_set_panel3(panel,panel_item,x,y) \
				panel_item=panel_create_item( panel,\
				PANEL_CYCLE,\
				PANEL_LABEL_STRING,"Select set:",\
	 			PANEL_CHOICE_STRINGS,\
			"Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",\
			"Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",\
			"Set 12", "Set 13", "Set 14", 0,\
	    		PANEL_ITEM_X,x,\
	    		PANEL_ITEM_Y,y,\
			0 );

extern Frame main_frame;
extern Canvas canvas;
extern Cursor cursor;
extern Pixfont *winfont;

Frame define_world_frame;
Panel define_world_panel;
static Panel_item define_world_xg1;	/* dimensions of axes */
static Panel_item define_world_xg2;
static Panel_item define_world_yg1;
static Panel_item define_world_yg2;
static Panel_item define_view_xv1;	/* viewport */
static Panel_item define_view_xv2;
static Panel_item define_view_yv1;
static Panel_item define_view_yv2;
static Panel_item autoscale_set_item;
Panel_item autoscale_type_item;	/* needed in grtool.c */
Panel_item auto_redraw_item;	/* needed in grtool.c */

static char buf[256];

/*
 * update the major items in define world/view popup and ticks
 * popup
 */
void updateparms()
{
    sprintf(buf, "%.5g", xg1);
    panel_set_value(define_world_xg1, buf);
    sprintf(buf, "%.5g", xg2);
    panel_set_value(define_world_xg2, buf);
    sprintf(buf, "%.5g", yg1);
    panel_set_value(define_world_yg1, buf);
    sprintf(buf, "%.5g", yg2);
    panel_set_value(define_world_yg2, buf);
    sprintf(buf, "%.5g", xv1);
    panel_set_value(define_view_xv1, buf);
    sprintf(buf, "%.5g", xv2);
    panel_set_value(define_view_xv2, buf);
    sprintf(buf, "%.5g", yv1);
    panel_set_value(define_view_yv1, buf);
    sprintf(buf, "%.5g", yv2);
    panel_set_value(define_view_yv2, buf);
}

/*
 * define the window coordinates, note that input is scanned for expressions
 */
static void define_world_proc(item, event)
    Panel_item item;
    Event *event;
{
    char val[80];
    int errpos;
    double x = (xg2 - xg1),	/* DX */
     y = (yg2 - yg1),		/* DY */
     a = xg1, b = yg1, c = xg2, d = yg2;
    extern double result;	/* result passed from the expression
				 * interpreter */

    strcpy(val, panel_get_value(define_world_xg1));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    xg1 = result;
    strcpy(val, panel_get_value(define_world_yg1));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    yg1 = result;
    strcpy(val, panel_get_value(define_world_xg2));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    xg2 = result;
    strcpy(val, panel_get_value(define_world_yg2));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    yg2 = result;
    drawgraph();
}

/*
 * define viewport
 */
static void define_view_proc(item, event)
    Panel_item item;
    Event *event;
{
    char val[80];
    double tmpx1, tmpx2;
    double tmpy1, tmpy2;
    int ierr = 0;

    strcpy(val, panel_get_value(define_view_xv1));
    tmpx1 = atof(val);
    strcpy(val, panel_get_value(define_view_xv2));
    tmpx2 = atof(val);
    strcpy(val, panel_get_value(define_view_yv1));
    tmpy1 = atof(val);
    strcpy(val, panel_get_value(define_view_yv2));
    tmpy2 = atof(val);
    if (!fbounds(tmpx1, 0.0, 1.0, "View xmin"))
	ierr = 1;
    else if (!fbounds(tmpx2, tmpx1, 1.0, "View xmax"))
	ierr = 1;
    else if (!fbounds(tmpy1, 0.0, 1.0, "View ymin"))
	ierr = 1;
    else if (!fbounds(tmpy2, tmpy1, 1.0, "View ymax"))
	ierr = 1;
    if (!ierr) {
	xv1 = tmpx1;
	xv2 = tmpx2;
	yv1 = tmpy1;
	yv2 = tmpy2;
	drawgraph();
    }
}

static void define_viewm_proc(item, event)
    Panel_item item;
    Event *event;
{
    set_action(0);
    set_action(VIEW_1ST);
    window_set(canvas, WIN_CURSOR, cursor, 0);
}

/*
 * pan through world coordinates
 */

/*
 * scroll amount
 */
static double scrollper = 0.95;

static void gwindleft_proc(item, event)
    Panel_item item;
    Event *event;
{
    double dx = scrollper * (xg2 - xg1);

    xg1 = xg1 - dx;
    xg2 = xg2 - dx;
    drawgraph();
}

static void gwindright_proc(item, event)
    Panel_item item;
    Event *event;
{
    double dx = scrollper * (xg2 - xg1);

    xg1 = xg1 + dx;
    xg2 = xg2 + dx;
    drawgraph();
}

static void gwinddown_proc(item, event)
    Panel_item item;
    Event *event;
{
    double dy = scrollper * (yg2 - yg1);

    yg1 = yg1 - dy;
    yg2 = yg2 - dy;
    drawgraph();
}

static void gwindup_proc(item, event)
    Panel_item item;
    Event *event;
{
    double dy = scrollper * (yg2 - yg1);

    yg1 = yg1 + dy;
    yg2 = yg2 + dy;
    drawgraph();
}

/*
 * set scroll amount
 */
static void scroll_proc(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    scrollper = value / 100.0;
}

void update_proc(item, event)
    Panel_item item;
    Event *event;
{
    updateparms();
}

static void autoscale_proc(item, event)
    Panel_item item;
    Event *event;
{
    if (activeset()) {
	defaultgraph();
	defaulttics((int) panel_get_value(autoscale_type_item));
	updateparms();
	drawgraph();
    } else
	errwin("No active sets!");
}

static void autoscale_set_proc(item, event)
    Panel_item item;
    Event *event;
{
    int value;

    value = (int) panel_get_value(autoscale_set_item);
    if (isactive(value)) {
	defaultsetgraph(value);
	defaulttics((int) panel_get_value(autoscale_type_item));
	updateparms();
	drawgraph();
    } else
	errwin("No active sets!");
}

static void do_zoom_proc(item, event)
    Panel_item item;
    Event *event;
{
    set_action(0);
    set_action(ZOOM_1ST);
    window_set(canvas, WIN_CURSOR, cursor, 0);
}

static void define_world_done_proc()
{
    window_set(define_world_frame, WIN_SHOW, FALSE, 0);
}

void define_world_popup()
{
    void autotick_proc();	/* defined in tickwin.c used here for
				 * convenience */

    define_world_frame = window_create(main_frame, FRAME,
				       FRAME_LABEL, "World/view",
				       FRAME_SHOW_LABEL, TRUE,
				       WIN_Y, 50,
				       WIN_FONT, winfont,
			WIN_ERROR_MSG, "Couldn't create define_world_frame",
				       0);
    define_world_panel = window_create(define_world_frame, PANEL,
				       WIN_FONT, winfont,
				WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				       0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_LABEL_IMAGE,
	 panel_button_image(define_world_panel, "Define world", 0, winfont),
		      PANEL_NOTIFY_PROC, define_world_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(15),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_LABEL_IMAGE,
		 panel_button_image(define_world_panel, "Zoom", 0, winfont),
		      PANEL_NOTIFY_PROC, do_zoom_proc,
		      0);
    define_world_xg1 = panel_create_item(define_world_panel, PANEL_TEXT,
					 PANEL_LABEL_STRING, "World Xmin: ",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(2),
					 PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_world_xg2 = panel_create_item(define_world_panel, PANEL_TEXT,
					 PANEL_LABEL_STRING, "World Xmax: ",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(3),
					 PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_world_yg1 = panel_create_item(define_world_panel, PANEL_TEXT,
					 PANEL_LABEL_STRING, "World Ymin: ",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(4),
					 PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_world_yg2 = panel_create_item(define_world_panel, PANEL_TEXT,
					 PANEL_LABEL_STRING, "World Ymax: ",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(5),
					 PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(7),
		      PANEL_LABEL_IMAGE,
	  panel_button_image(define_world_panel, "Define view", 0, winfont),
		      PANEL_NOTIFY_PROC, define_view_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(define_world_panel, "Define view by mouse", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(8),
		      PANEL_NOTIFY_PROC, define_viewm_proc,
		      0);
    define_view_xv1 = panel_create_item(define_world_panel, PANEL_TEXT,
					PANEL_LABEL_STRING, "View Xmin: ",
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(9),
					PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_view_xv2 = panel_create_item(define_world_panel, PANEL_TEXT,
					PANEL_LABEL_STRING, "View Xmax: ",
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(10),
					PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_view_yv1 = panel_create_item(define_world_panel, PANEL_TEXT,
					PANEL_LABEL_STRING, "View Ymin: ",
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(11),
					PANEL_VALUE_DISPLAY_LENGTH, 15, 0);
    define_view_yv2 = panel_create_item(define_world_panel, PANEL_TEXT,
					PANEL_LABEL_STRING, "View Ymax: ",
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(12),
					PANEL_VALUE_DISPLAY_LENGTH, 15, 0);

    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(14),
		      PANEL_LABEL_IMAGE,
	   panel_button_image(define_world_panel, "Left", 0, (Pixfont *) 0),
		      PANEL_NOTIFY_PROC, gwindleft_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(7),
		      PANEL_ITEM_Y, ATTR_ROW(14),
		      PANEL_LABEL_IMAGE,
	  panel_button_image(define_world_panel, "Right", 0, (Pixfont *) 0),
		      PANEL_NOTIFY_PROC, gwindright_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(5),
		      PANEL_ITEM_Y, ATTR_ROW(13),
		      PANEL_LABEL_IMAGE,
	     panel_button_image(define_world_panel, "Up", 0, (Pixfont *) 0),
		      PANEL_NOTIFY_PROC, gwindup_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(5),
		      PANEL_ITEM_Y, ATTR_ROW(15),
		      PANEL_LABEL_IMAGE,
	   panel_button_image(define_world_panel, "Down", 0, (Pixfont *) 0),
		      PANEL_NOTIFY_PROC, gwinddown_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_SLIDER,
		      PANEL_ITEM_X, ATTR_COL(18),
		      PANEL_ITEM_Y, ATTR_ROW(14),
		      PANEL_LABEL_STRING, "Scroll %",
		      PANEL_VALUE, 95,
		      PANEL_MIN_VALUE, 1,
		      PANEL_MAX_VALUE, 100,
		      PANEL_NOTIFY_PROC, scroll_proc,
		      0);

    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(define_world_panel, "Update world and view", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(17),
		      PANEL_NOTIFY_PROC, update_proc,
		      0);

    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	    panel_button_image(define_world_panel, "Autoscale", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(19),
		      PANEL_NOTIFY_PROC, autoscale_proc,
		      0);
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	   panel_button_image(define_world_panel, "Auto ticks", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(15),
		      PANEL_ITEM_Y, ATTR_ROW(19),
		      PANEL_NOTIFY_PROC, autotick_proc,
		      0);
    define_select_set_panel3(define_world_panel, autoscale_set_item, ATTR_COL(25), ATTR_ROW(20));
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
     panel_button_image(define_world_panel, "Autoscale on set", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(20),
		      PANEL_NOTIFY_PROC, autoscale_set_proc,
		      0);
    autoscale_type_item = panel_create_item(define_world_panel, PANEL_CYCLE,
					    PANEL_ITEM_X, ATTR_COL(1),
					    PANEL_ITEM_Y, ATTR_ROW(22),
				      PANEL_LABEL_STRING, "Autoscale mode:",
					    PANEL_CHOICE_STRINGS,
					    "Adjustable spacing",
					    "Fixed spacing",
					    0,
					    0);
    auto_redraw_item = panel_create_item(define_world_panel, PANEL_CYCLE,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(23),
					 PANEL_LABEL_STRING, "Draw mode:",
					 PANEL_CHOICE_STRINGS,
					 "Auto re-draw",
					 "No auto redraw",
					 0,
					 0);
/* some day...

    graph_type_item = panel_create_item(define_world_panel, PANEL_CYCLE,
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(24),
					PANEL_LABEL_STRING, "Graph type:",
					PANEL_CHOICE_STRINGS,
					"X-Y",
					"Bar graph",
					"Stacked bar",
					"Adjacent bar",
					"Polar",
					0,
					0);
*/
    panel_create_item(define_world_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(define_world_panel, "Done", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(25),
		      PANEL_NOTIFY_PROC, define_world_done_proc,
		      0);
/*
 * define the items for multiple graphs - in graphwin.c
 */
    define_graphops();
    window_fit(define_world_panel);
    window_fit(define_world_frame);
}
