
/*
 *           PVM 3.0:  Parallel Virtual Machine System 3.0
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *          R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM 3.0 was funded in part by the U.S. Department of Energy, the
 * National Science Foundation and the State of Tennessee.
 */

/*
 *	myalloc.h
 *
 *	Malloc filter interface.
 *
$Log$
 */

#ifdef	USE_PVM_ALLOC
#define	PVM_ALLOC(n,g)		pvm_alloc((unsigned)(n),(g))
#define	PVM_REALLOC(p,n)	pvm_realloc((char*)(p),(unsigned)(n))
#define	PVM_FREE(p)			pvm_free((char*)(p))

#else
#define	PVM_ALLOC(n,g)		malloc((unsigned)(n))
#define	PVM_REALLOC(p,n)	realloc((char*)(p),(unsigned)(n))
#define	PVM_FREE(p)			free((char*)(p))
#endif

#define	TALLOC(n,t,g)		(t*)PVM_ALLOC((n)*sizeof(t),(g))
#define	TREALLOC(p,n,t)		(t*)PVM_REALLOC(p,(n)*sizeof(t))

#define	STRALLOC(s)			strcpy(TALLOC(strlen(s)+1,char,"str"),s)

char *pvm_alloc __ProtoGlarp__((unsigned n, char *g));
char *pvm_realloc __ProtoGlarp__((char *p, unsigned n));
void pvm_free __ProtoGlarp__((char *p));

