#ifndef lint
static char SCCSid[] = "@(#) ./xtools/vfp/vfp.c 07/23/93";
#endif

/* 
    This file contains routines that provide a "virtual front panel"
    for a parallel job.  This code uses the ability to set a routine
    to be executed with every state change to issue the graphics calls.
    We also take advantage of the fact that in X, only the window id 
    is needed to enable drawing on a window.  Note that this requires
    one connection to the server for each worker; this may be excessive
    with massively parallel jobs.
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/vfp/message.h"
#include "system/state.h"        /*I "system/state.h" I*/

typedef struct {
    XBWindow *win;           /* Window do draw on */
    PixVal   color;          /* Color to use */
    int      x, y, w, h;     /* Location to draw on */
    } VFPCtx;
static XBWindow mywindow;

/* @
  VFPInit2 - Initialize the Virtual Front Panel 

  Input Parameters:
. win - X11 Window
. host - name of display server
. rows - number of rows in panel
. cols - number of columns in panel 
. w    - width and height of a cell in the panel, in pixels

  Note:
  All processors must call this routine.
@ */
int VFPInit2( win, host, rows, cols, w )
Window win;
char *host;
int  rows, cols, w;
{

if (!win) {
    XBQuickWindow( &mywindow, host, "VFP", -1, -1, cols*w, rows*w );
    win = mywindow.win;
    }
else {
    XBQuickWindowFromWindow( &mywindow, host, win );
    }
return (int)win;
}

/*@
    VFPStateChange - change the state of a cell in a VFP

    Input Parameters:
.   state - state structure
.   flag  - 1 for on, 0 for off

    Note:
    The private part of a state context must have been set with 
    VFPStateDefine.
@*/
void VFPStateChange( state, flag )
SYstate *state;
int     flag;
{
VFPCtx   *ctx = (VFPCtx *)state->rcontext;
XBWindow *win = ctx->win;
 
/* Compute location */
if (flag) 
    XSetForeground( win->disp, win->gc.set, ctx->color );
else 
    XSetForeground( win->disp, win->gc.set, win->cmapping[0] );

XFillRectangle( win->disp, XBDrawable(win), win->gc.set, 
                ctx->x, ctx->y, ctx->w, ctx->h );

/* Realtime, so ask the library to send the request on out */
XBFlush( win->disp );
}

/*@
    VFPStateDefine - Define and set up a state

    Input Parameters:
.   state - state to set
.   color - color for the "on" state
.   row,col - location of the cell in the VFP
.   w       - size of the cell (width and height)    
@*/  
void VFPStateDefine( state, color, row, col, w )
SYstate *state;
int     color;
int     row, col, w;
{
VFPCtx *ctx;
state->routine  = VFPStateChange;
state->rcontext = ctx = NEW(VFPCtx);    CHKPTR(ctx);
ctx->win   = &mywindow;
ctx->color = color;
/* Compute the elements of ctx */
ctx->x = col*w;
ctx->y = row*w; 
ctx->w = w;
ctx->h = w;
}

/*@
    VFPColor - Given a color name, return the pixel value for it

    Input Parameter:
.   name - name of a color, such as "red"
@*/
PixVal VFPColor( name )
char *name;
{
PixVal pixval;
XBFindColor( &mywindow, name, &pixval );
return pixval;
}

static XBFont  font;
/*
    VFPInit - Initialize the virtual front panel, given an XWindow.
    This handles all of the decorations
 */
VFPInfo *VFPInit3( XBWin, nx, ny, placement )
XBWindow *XBWin;
int      nx, ny;
void     (*placement)();
{
VFPInfo *info;
int     x = 0, y = 0;

XBInitFonts( XBWin ) ;
XBMatchFontSize( &font, 9, 15 ) ;
XBLoadFont( XBWin, &font ) ;  

/**** IS THIS NECESSARY?,  SEEMS TO BE THE ONLY WAY TO GET FONTS TO WORK ****/
{
    XGCValues  values ;
    values.font = font.fnt ;
    XChangeGC( XBWin->disp, XBWin->gc.set, GCFont, &values ) ; 
}

info = VFPInit( XBWin, &font, nx*ny, 30, 30, x, y );
VFPFillProcCoordGrid2d( info, XBWin->w, XBWin->h, nx, ny ) ;
XBFrameColorsByName( XBWin, "gray85", "gray65" );

#ifdef FOO
/**************/
  pix1 = XCreatePixmapFromBitmapData(XBWin.disp, XBWin.win, 
      ltgrey, 8, 8, 1, 0, 1);  
  pix2 = XCreatePixmapFromBitmapData(XBWin.disp, XBWin.win, 
      white, 8, 8, 1, 0, 1);  

  Box1 = (XB3DBoxStruct*)XBInit3DBox( 1, 1, height-5, width-5, 5, 1, pix1 ) ;
  Box2 = (XB3DBoxStruct*)XBInit3DBox( 50, 100, height-155, width-105, 3, 0, pix2 ) ;
  XBDraw3DBox( &XBWin, Box1 ) ;
  XBDraw3DBox( &XBWin, Box2 ) ;
  XBFree3DBox( Box1 ) ;  
  XBFree3DBox( Box2 ) ; 

  text_info = (XBTextBoxStruct*)XBInitTextBox( 50, 35, width-105, 30, CENTER, 
      "Processor Message Display" ) ;
  XBDrawTextBox( &XBWin, &font, text_info ) ;

  XBFreeTextBox( text_info ) ;
#endif

/* Eventually, only prime processor OR each processor draws their own */
VFPDrawProcRects( info ) ;
if( VFPSetMsgColor( info, 160, 32, 240, 10, 0 ) )
    printf( "**** did not set message color correctly ****\n") ;

return info;
}


/* For now, special code to process log events */
#define LOG_SENDS 103
#define LOG_SENDE 104
#define LOG_RECVS 105
#define LOG_RECVE 106
#define LOG_RECVWS 107
#define LOG_RECVWE 108
static char *states[] = {"-- Waiting for Message","-- Sending Message",
		    "-- Receiving Message", "-- Processing" }  ;

void VFPInitForLog( info )
VFPInfo *info;
{
Pixmap        pixmap1,
              pixmap2, pixmap3, pixmap4 ;
XBWindow     *XBWin=info->XBWin ;
/* some stipples, (most not very good) */
static char grey[] = {
   0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55};
static char ltgrey[] = {
   0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55};
static char white[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static char black[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

pixmap1 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
				      grey, 8, 8, 1, 0, 1);  
pixmap2 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
				      ltgrey, 8, 8, 1, 0, 1);  
pixmap3 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
				      black, 8, 8, 1, 0, 1);  
pixmap4 = XCreatePixmapFromBitmapData(XBWin->disp, XBWin->win, 
				      grey, 8, 8, 1, 0, 1);  

VFPDefineStateBW( info, 0, pixmap1 );
VFPDefineStateBW( info, 1, pixmap1 );
VFPDefineStateBW( info, 2, pixmap2 );
VFPDefineStateBW( info, 3, pixmap3 );
VFPDefineStateBW( info, 4, pixmap4 );
VFPDefineStateColor( info, 0, "gray" );     /* connections */
VFPDefineStateColor( info, 1, "yellow" );   /* recv */
VFPDefineStateColor( info, 2, "blue" );     /* send */
VFPDefineStateColor( info, 3, "red" );      /* recv idle */
VFPDefineStateColor( info, 4, "green" );    /* working (not communicating) */
}

void VFPDrawForLog( info, myp, from, to, len, state )
VFPInfo *info;
int     myp, from, to, len, state;
{
if (from >= 0 && to >= 0)
    /* transfers are state 0 */
    VFPDrawConnection( info, from, to, len, 
		       state != LOG_RECVE && state != LOG_RECVWE );

switch (state) {
    case LOG_RECVS:
        VFPSetState( info, myp, 1 ); break;
    case LOG_SENDS:
	VFPSetState( info, myp, 2 ); break;
    case LOG_RECVWS:
        VFPSetState( info, myp, 3 ); break;

    case LOG_RECVE:
    case LOG_SENDE:
    case LOG_RECVWE:
	VFPSetState( info, myp, 4 ); break;
    }
}

void VFPDrawIndex( XBWin, info, x, y, width, height, labels, nentries ) 
     XBWindow    *XBWin ;
     VFPInfo     *info;
     int          x, y,
                  width,
                  height ;
     char       **labels ;
     int          nentries ; 
{
  int     border = 10,
          fh        = font.font_h,
          rect_size,
          i,
          vspacing ;

  if (fh <= 0) fh = 15;
  rect_size = fh;

  /* clear area and draw border rectangle */
  XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->background ) ;
  XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		  x, y, width+1, height+1 ) ;
  XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground ) ;
  XDrawRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		  x, y, width, height ) ;

  /* draw the entries */
  vspacing = (height - nentries*rect_size - 2*border) / (nentries-1) ;
  for( i=0 ; i<nentries ; i++ ) 
    {
      /* draw the filled in rectangle */
      XDrawRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		      x+border, y+border+
          i*(rect_size+vspacing), rect_size, rect_size ) ;

      if( XBWin->numcolors > 2 )
	  XSetForeground( XBWin->disp, XBWin->gc.set, info->dp[i] ) ;
      else
	{
	  /* printf( " 1 B&W display - using pixmap\n" ) ; */
	  XSetFillStyle( XBWin->disp, XBWin->gc.set, FillStippled );
	  XSetStipple( XBWin->disp, XBWin->gc.set, info->dpm[i] );
	}
      XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		     x+border+1, 
		     y + border + i*(vspacing+rect_size) + 1, 
	       rect_size-1, rect_size-1 ) ;

     if( XBWin->maxcolors <= 2 )
	XSetFillStyle( XBWin->disp, XBWin->gc.set, FillSolid );
      else
      XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground ) ;

      /* draw the label */
      XDrawString( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set, 
		  x+2*border+rect_size, 
		  y + border + i*(vspacing+rect_size) + 
		  fh - font.font_descent, 
		  labels[i], strlen( labels[i] ) ) ;
    }
  XFlush( XBWin->disp ) ;
}


/* 0-use current, 1-use default, 2-allocate basic*/

/********  FIX THIS ***********/

int VFPSetMsgColor(info, init_red, init_green, init_blue, size, cmap_flag ) 
     VFPInfo  *info ;
     unsigned char init_red, init_green, init_blue ;
     int           size, cmap_flag ;

{
  XBWindow  *XBWin=info->XBWin ;
  unsigned char *red, *green, *blue ;
  int           i,j,err=0, start ;

  PixVal  temp ;

  start = XBWin->maxcolors ;

  red = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 
  green = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 
  blue = (unsigned char*)MALLOC( size * sizeof( unsigned char ) ) ; 

  red[0]   = init_red ; 
  green[0] = init_green ; 
  blue[0]  = init_blue ; 
  XBSetCmapLight( red, green, blue, size ) ;

  switch( cmap_flag )
    {
    case 0:
    /* printf( " using given colormap \n" ) ; */
      /* try to use given color map */
      if( XBWin->cmap ) {
	if( XBAddCmap( red, green, blue, size, XBWin ) )
	  {
	    printf( "error in adding colors \n" ) ;
	    err = 1 ;
	  }
	/* else
	  printf( " added colors\n" ) ; */
	}
      else
	  {
	    printf( " no given color map\n" ) ; 
	    err = 1 ;
	  }
      break ;

    case 1:
      /* printf( " using the default colormap \n" ) ; */
      /* try to use default color map */
      XBWin->cmap = DefaultColormap( XBWin->disp, XBWin->screen ) ;
      if( XBAddCmap( red, green, blue, size, XBWin ) )
	{
	  printf( "error in adding colors \n" ) ;
	  err = 1 ;
	}
      /* else
	printf( " added colors\n" ) ; */
      break ;

    case 2:
      /* printf( " allocating basic colormap \n" ) ; */
      /* allocate basic colormap */
      XBWin->cmap = (Colormap)0 ;
      XBInitColors( XBWin ) ;
      if( XBAddCmap( red, green, blue, size, XBWin ) )
	{
	  printf( "error in adding colors \n" ) ;
	  err = 1 ;
	}
      /* else
	printf( " added colors\n" ) ; */
      break ;
    }

  /* copy mapping into msg_cmap */

/*


  if( XBCmap( red, green, blue, size, XBWin ) )
    printf( " error in initiating colors\n" ) ;
  else
    printf( " initated colors\n" ) ;
*/

  FREE( red ) ;
  FREE( green ) ;
  FREE( blue ) ;

  return( err ) ;
}
