      SUBROUTINE T3SPER( VRP, VUP, VPN, COP, B, UMIN, UMAX, VMIN, VMAX,
     * MAT, PERMAT, HALWID )
      DOUBLE PRECISION    VRP(3), VUP(3), VPN(3), COP(3), B, UMIN, UMAX,
     * VMIN, VMAX, MAT(4,4), PERMAT(4,4), HALWID
      DOUBLE PRECISION    RZ(3), TPER(3), VRPP(4), A2, B2, CW(3), S(3),
     * TIVNRM, D, SCALE
      INTEGER I, J
      DO 23000 I=1, 4
      DO 23002 J=1,4
      MAT(J,I)    = 0.0
23002 CONTINUE
23000 CONTINUE
      MAT(4,4)    = 1.0
      DO 23004 I=1,3
      TPER(I)    = - ( VRP(I) + COP(I) )
23004 CONTINUE
      D   = TIVNRM( VPN )
      DO 23006 I=1, 3
      RZ(I)   = - VPN(I) / D
23006 CONTINUE
      CALL TIVX( VPN, VUP, MAT(1,1) )
      CALL TIVUNI( MAT(1,1) )
      CALL TIVX( RZ, MAT(1,1), MAT(1,2) )
      DO 23008 I=1,3
      MAT(I,3)    = RZ(I)
      MAT(4,1)    = MAT(4,1) + TPER(I) * MAT(I,1)
      MAT(4,2)    = MAT(4,2) + TPER(I) * MAT(I,2)
      MAT(4,3)    = MAT(4,3) + TPER(I) * RZ(I)
23008 CONTINUE
      DO 23010 I=1, 4
      MAT(I,3)    = - MAT(I,3)
23010 CONTINUE
      DO 23012 I=1,4
      VRPP(I)     = MAT(4,I)
      DO 23014 J=1,3
      VRPP(I) = VRPP(I) + VRP(J) * MAT(J,I)
23014 CONTINUE
23012 CONTINUE
      CW(1)   = VRPP(1) + 0.5 * (UMIN + UMAX)
      CW(2)   = VRPP(2) + 0.5 * (VMIN + VMAX)
      CW(3)   = VRPP(3)
      A2      = - CW(1) / CW(3)
      B2      = - CW(2) / CW(3)
      DO 23016 I=1, 4
      MAT(I,1)    = MAT(I,1) + A2 * MAT(I,3)
      MAT(I,2)    = MAT(I,2) + B2 * MAT(I,3)
23016 CONTINUE
      HALWID = VRPP(3) / ( VRPP(3) + B )
      SCALE   = MAX( UMAX - UMIN, VMAX - VMIN )
      S(1)    = 2.0 * HALWID / SCALE
      S(2)    = 2.0 * HALWID / SCALE
      S(3)    = 1.0 / ( VRPP(3) + B )
      DO 23018 I=1, 4
      MAT(I,1)    = MAT(I,1) * S(1)
      MAT(I,2)    = MAT(I,2) * S(2)
      MAT(I,3)    = MAT(I,3) * S(3)
23018 CONTINUE
      DO 23020 I=1, 4
      DO 23022 J=1, 4
      PERMAT(J,I) = 0.0
23022 CONTINUE
23020 CONTINUE
      PERMAT(1,1) = 1.0
      PERMAT(2,2) = 1.0
      PERMAT(3,3) = 1.0
      PERMAT(3,4) = 1.0 / HALWID
      RETURN
C HALFWID = HALWID
      END
      SUBROUTINE T3MPER( THETA, PHI, EYEIST, SCRIST, VRP, VUP, VPN, COP,
     * B, UMIN, UMAX, VMIN, VMAX )
      DOUBLE PRECISION    THETA, PHI, EYEIST, SCRIST, VRP(3), VUP(3),
     * VPN(3), COP(3), B, UMIN, UMAX, VMIN, VMAX
      DOUBLE PRECISION    V(3), TH, PH
      INTEGER I
      PH      = PHI * 1.745329E-02
      TH      = THETA * 1.745329E-02
      V(1)    = SIN( PH ) * COS( TH )
      V(2)    = SIN( PH ) * SIN( TH )
      V(3)    = COS( PH )
      DO 23000 I=1,3
      COP(I)  = EYEIST * V(I)
      VRP(I)  = 0.5 + SCRIST * V(I)
      VPN(I)  = -V(I)
23000 CONTINUE
      VUP(1)  = - COS( PH ) * COS( TH )
      VUP(2)  = - COS( PH ) * SIN( TH )
      VUP(3)  = SIN( PH )
      B       = SCRIST + SQRT( 3.0D0 ) / 2.0D0
      UMIN    = - 0.5 * SQRT( 3.0D0 ) * ( EYEIST - SCRIST ) / EYEIST
      UMAX    = - UMIN
      VMIN    = UMIN
      VMAX    = UMAX
      RETURN
C SCRDIST = SCRIST
C EYEDIST = EYEIST
      END
      SUBROUTINE T3PER( THETA, PHI, R, MAT, PERMAT, HALWID )
      DOUBLE PRECISION    THETA, PHI, R, MAT(4,4), PERMAT(4,4), HALWID
      DOUBLE PRECISION    VRP(3), VUP(3), VPN(3), COP(3), B, UMIN, UMAX,
     * VMIN, VMAX
      CALL T3MPER( THETA, PHI, R, 0.5D0 * SQRT(3.0D0), VRP, VUP, VPN,
     * COP, B, UMIN, UMAX, VMIN, VMAX )
      CALL T3SPER( VRP, VUP, VPN, COP, B, UMIN, UMAX, VMIN, VMAX, MAT,
     * PERMAT, HALWID )
      PERMAT(1,1) = .5
      PERMAT(2,2) = .5
      PERMAT(4,1) = .5
      PERMAT(4,2) = .5
      RETURN
C HALFWID = HALWID
      END
      SUBROUTINE T3APER( PERMAT, W, H, X, Y )
      DOUBLE PRECISION    PERMAT(4,4), W, H, X, Y
      PERMAT(1,1) = PERMAT(1,1) * W
      PERMAT(2,2) = PERMAT(2,2) * H
      PERMAT(3,1) = PERMAT(3,4) * X
      PERMAT(3,2) = PERMAT(3,4) * Y
      PERMAT(4,1) = PERMAT(4,1) * W
      PERMAT(4,2) = PERMAT(4,2) * H
      RETURN
      END
      SUBROUTINE TIVX( U, V, UXV )
      DOUBLE PRECISION    U(3), V(3), UXV(3)
      UXV(1)  = U(2) * V(3) - U(3) * V(2)
      UXV(2)  = U(3) * V(1) - U(1) * V(3)
      UXV(3)  = U(1) * V(2) - U(2) * V(1)
      RETURN
      END
      DOUBLE PRECISION FUNCTION TIVNRM( V )
      DOUBLE PRECISION    V(3)
      TIVNRM= SQRT( V(1)**2 + V(2)**2 + V(3)**2 )
      RETURN
      END
      SUBROUTINE TIVUNI( V )
      DOUBLE PRECISION    V(3)
      DOUBLE PRECISION    TIVNRM, D
      INTEGER I
      D   = TIVNRM( V )
      IF (D .EQ. 0.0) THEN
      RETURN
      ENDIF
      DO 23000 I=1, 3
      V(I)    = V(I) / D
23000 CONTINUE
      RETURN
      END
      SUBROUTINE TITRAN( V, MAT, PERMAT, X, Y )
      DOUBLE PRECISION    V(3), MAT(4,4), PERMAT(4,4), X, Y
      DOUBLE PRECISION    SUM, D
      INTEGER      I, J
      X       = 0.0
      Y       = 0.0
      D       = 0.0
      DO 23000 J=1, 4
      SUM     = MAT(4,J)
      DO 23002 I=1, 3
      SUM     = SUM + V(I) * MAT(I,J)
23002 CONTINUE
      X       = X + SUM * PERMAT(J,1)
      Y       = Y + SUM * PERMAT(J,2)
      D       = D + SUM * PERMAT(J,4)
23000 CONTINUE
      X       = X / D
      Y       = Y / D
      RETURN
      END
      SUBROUTINE T2TRAN( V, CMAT, X, Y )
      DOUBLE PRECISION    V(3), CMAT(4,4), X, Y
      DOUBLE PRECISION    D
      X = CMAT(4,1) + V(1)*CMAT(1,1)+V(2)*CMAT(2,1)+V(3)*CMAT(3,1)
      Y = CMAT(4,2) + V(1)*CMAT(1,2)+V(2)*CMAT(2,2)+V(3)*CMAT(3,2)
      D = CMAT(4,4) + V(1)*CMAT(1,4)+V(2)*CMAT(2,4)+V(3)*CMAT(3,4)
      X       = X / D
      Y       = Y / D
      RETURN
      END
      SUBROUTINE TACMAT( MAT, PERMAT, CMAT )
      DOUBLE PRECISION MAT(4,4), PERMAT(4,4), CMAT(4,4)
      INTEGER I, J, K
      DOUBLE PRECISION SUM
      DO 23000 I=1,4
      DO 23002 J=1,4
      SUM = 0.0
      DO 23004 K=1,4
      SUM = SUM + MAT(I,K) * PERMAT(K,J)
23004 CONTINUE
      CMAT(I,J) = SUM
23002 CONTINUE
23000 CONTINUE
      RETURN
      END
      SUBROUTINE TJTAN3( N, X, Y, Z, MAT, PERMAT, WX, WY, WZ )
      INTEGER      N
      DOUBLE PRECISION    X(*), Y(*), Z(*), MAT(4,4), PERMAT(4,4), WX(*)
     *, WY(*), WZ(*)
      DOUBLE PRECISION    SUM, D
      INTEGER      J, K
      DO 23000 K=1, N
      WX(K)    = 0.0
      WY(K)    = 0.0
      WZ(K)    = 0.0
      D        = 0.0
      DO 23002 J=1, 4
      SUM = MAT(4,J) + X(K) * MAT(1,J) + Y(K) * MAT(2,J) + Z(K) * MAT(3,
     *J)
      WX(K)   = WX(K) + SUM * PERMAT(J,1)
      WY(K)   = WY(K) + SUM * PERMAT(J,2)
      WZ(K)   = WZ(K) + SUM * PERMAT(J,3)
      D       = D + SUM * PERMAT(J,4)
23002 CONTINUE
      WX(K)    = WX(K) / D
      WY(K)    = WY(K) / D
23000 CONTINUE
      RETURN
      END
      SUBROUTINE TITAN3( N, X, Y, Z, MAT, PERMAT, WX, WY, WZ )
      INTEGER      N
      DOUBLE PRECISION    X(*), Y(*), Z(*), MAT(4,4), PERMAT(4,4), WX(*)
     *, WY(*), WZ(*)
      DOUBLE PRECISION    SUM, D
      INTEGER      K
      DO 23000 K=1, N
      SUM = X(K) * MAT(1,1) + Y(K) * MAT(2,1) + Z(K) * MAT(3,1) + MAT(4,
     *1)
      WX(K)    = SUM * PERMAT(1,1)
      SUM = X(K) * MAT(1,2) + Y(K) * MAT(2,2) + Z(K) * MAT(3,2) + MAT(4,
     *2)
      WY(K)    = SUM * PERMAT(2,2)
      SUM = X(K) * MAT(1,3) + Y(K) * MAT(2,3) + Z(K) * MAT(3,3) + MAT(4,
     *3)
      WX(K)   = WX(K) + SUM * PERMAT(3,1)
      WY(K)   = WY(K) + SUM * PERMAT(3,2)
      WZ(K)    = SUM * PERMAT(3,3)
      D        = SUM * PERMAT(3,4)
      SUM     = MAT(4,4)
      WX(K)   = WX(K) + SUM * PERMAT(4,1)
      WY(K)   = WY(K) + SUM * PERMAT(4,2)
      WX(K)    = WX(K) / D
      WY(K)    = WY(K) / D
23000 CONTINUE
      RETURN
      END
      SUBROUTINE TKTAN3( N, VIN, MAT, PERMAT, WOUT )
      INTEGER      N
      DOUBLE PRECISION    VIN(3,*), MAT(4,4), PERMAT(4,4), WOUT(3,*)
      DOUBLE PRECISION    SUM, D
      INTEGER      K
      DO 23000 K=1, N
      SUM = VIN(1,K) * MAT(1,1) + VIN(2,K) * MAT(2,1) + VIN(3,K) * MAT(3
     *,1) + MAT(4,1)
      WOUT(1,K)    = SUM * PERMAT(1,1)
      SUM = VIN(1,K) * MAT(1,2) + VIN(2,K) * MAT(2,2) + VIN(3,K) * MAT(3
     *,2) + MAT(4,2)
      WOUT(2,K)    = SUM * PERMAT(2,2)
      SUM = VIN(1,K) * MAT(1,3) + VIN(2,K) * MAT(2,3) + VIN(3,K) * MAT(3
     *,3) + MAT(4,3)
      WOUT(1,K)   = WOUT(1,K) + SUM * PERMAT(3,1)
      WOUT(2,K)   = WOUT(2,K) + SUM * PERMAT(3,2)
      WOUT(3,K)    = SUM * PERMAT(3,3)
      D            = SUM * PERMAT(3,4)
      SUM     = MAT(4,4)
      WOUT(1,K)   = WOUT(1,K) + SUM * PERMAT(4,1)
      WOUT(2,K)   = WOUT(2,K) + SUM * PERMAT(4,2)
      WOUT(1,K)    = WOUT(1,K) / D
      WOUT(2,K)    = WOUT(2,K) / D
23000 CONTINUE
      RETURN
      END
C TITRAN3 = TITAN3
C TKTRAN3 = TKTAN3
C TJTRAN3 = TJTAN3
C T3ADPER = T3APER
