#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/base3d.h"
#include <math.h>

main( argc, argv )
int argc;
char **argv;
{
XBWindow      *XBWin;
int           i, j;
double        r, theta, phi;
int           px = -1, py = -1, pw = 200, ph = 200;
int           drawsides = 1;
XBGraphObject *Obj;
XBTrans3d     *Transform;
int           dumptriangles = 0;
Color         color;

XBWin = XBWinCreate();
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s [-nosides] Rotating surface example\n", argv[0] );
    exit(0);
    }
if (SYArgHasName( &argc, argv, 1, "-nosides" )) drawsides = 0;
if (SYArgHasName( &argc, argv, 1, "-dump" ))    dumptriangles = 1;

XBGetArgs( &argc, argv, 1, &px, &py, &pw, &ph );
if (XBQuickWindow( XBWin, "", "Surface", px, py, pw, ph )) {
    fprintf( stderr, "Check your DISPLAY variable\n" );
    exit(0);
    }

/* Generate the 3-d object */
if (SYArgHasName( &argc, argv, 1, "-sphere" )) {
    Obj     = XB3dCreateGraphObject( 1000, 2000 );    CHKPTR(Obj);
    Obj->nt = 0;
    XBFindColor( XBWin, "red", &color );
    XB3dAddSphere( 1.0, 10, Obj, color );
    }
else if (SYArgHasName( &argc, argv, 1, "-saucer" )) {
    Obj = XB3dCreateGraphObject( 80, 160 );     CHKPTR(Obj);
    CreateSaucer( XBWin, Obj );
    }
else {
    Obj = XB3dCreateGraphObject( 4, 4 );        CHKPTR(Obj);
    CreateTetra( XBWin, Obj );
    }

r     = 10.0;
theta = 30.0;
phi   = 60.0;
Transform = XB3dCreateTransform( );

if (dumptriangles) {
    XBSurfaceComputeView( r, theta, phi, Transform->mat, Transform->permat );
    XB3dScaleTransform( XBWin->w/2, XBWin->h/2, XBWin->w, XBWin->h, Transform );
    XB3dDump( XBWin, Obj, Transform, stdout );
    return 0;
    }
for (i=0; i<720; i++) {
    theta += 0.5;
    XBSurfaceComputeView( r, theta, phi, Transform->mat, Transform->permat );
    XB3dScaleTransform( XBWin->w/2, XBWin->h/2, XBWin->w, XBWin->h, Transform );

    XBClearWindow( XBWin, 0, 0, 200, 200 );
    XSetForeground( XBWin->disp, XBWin->gc.set, XBWin->foreground );
    /* Draw the 3-d object */
    if (drawsides)
	XB3dFill( XBWin, Obj, Transform, 0 );
    XB3dDraw( XBWin, Obj, Transform );
    XBFlush( XBWin );
    }
sleep(2);
return 0;
}

CreateTetra( XBWin, t )
XBWindow      *XBWin;
XBGraphObject *t;
{
PixVal backpixel, f0, f1, f2, f3;
XBTriangle tris[4];
double x[4], y[4], z[4];

/* Define a simple tetrahedron */
XBFindColor( XBWin, "red", &f0 );
XBFindColor( XBWin, "green", &f1 );
XBFindColor( XBWin, "blue", &f2 );
XBFindColor( XBWin, "yellow", &f3 );
x[0] = 0.0; y[0] = 0.0; z[0] = 0.0;
x[1] = 1.0; y[1] = 0.0; z[1] = 0.0;
x[2] = 0.0; y[2] = 1.0; z[2] = 0.0;
x[3] = 0.5; y[3] = 0.5; z[3] = 1.0;
XB3dDefineVerticesFromXYZ( t, 4, x, y, z );
XBSetVertexIndex( tris,   0, 1, 2 );
XBSetVertexIndex( tris+1, 0, 3, 1 );
XBSetVertexIndex( tris+2, 0, 2, 3 );
XBSetVertexIndex( tris+3, 1, 3, 2 );
tris[0].color = f0;
tris[1].color = f1;
tris[2].color = f2;
tris[3].color = f3;
XB3dDefineTriangles( t, 4, tris );
XBBaseLightModel( t );
}

CreateSaucer( XBWin, t )
XBWindow      *XBWin;
XBGraphObject *t;
{
PixVal backpixel, f0, f1, f2, f3;
XBTriangle tris[400];
double x[400], y[400], z[400];
double r, xoff, yoff, theta;
int    i, n;

/* Define a simple saucer */
n  = 80;
r  = 0.5;
xoff = r;
yoff = r;
for (i=0; i<n; i++) {
    theta = i * 2 * M_PI / n;
    x[i] = r * sin(theta) + xoff;
    y[i] = r * cos(theta) + yoff;
    z[i] = 0.0;
    XBSetVertexIndex( tris + i, i, (i+1)%n, n );
    tris[i].color  = i;
    }
/* Center point */
x[n] = xoff;
y[n] = yoff;
z[n] = 0.2;
XB3dDefineTriangles( t, n, tris );
XB3dDefineVerticesFromXYZ( t, n+1, x, y, z );
XBBaseLightModel( t );
}
