#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"
#define NO_GENERIC_SPARSE
#include "sparse/spmat.h"           /*I "sparse/spmat.h" I*/

#include <math.h>

extern XBWindow *XBQGetWindow();

/* Routine for displaying a row */
static void (*DrawRow)() = 0;

/*@
     XBQMatrix - Displays a sparse matrix on the display.

     This uses the "quick" window; if there is no "quick" window, 
     one is created

     Input Parameters:
.    mat - matrix
.    nc  - number of colors to use
@*/
void XBQMatrix( mat, nc )
SpMat *mat;
int   nc;
{
XBWindow *XBWin = XBQGetWindow( "Matrix", "" );
int      sr, er, sc, ec;
int      *ia, i, j, n, nz;
double   *a, minv, maxv, imap[256];

maxv = minv = 0.0;
n    = mat->rows;
for (i=0; i<n; i++) {
    SpScatterFromRow( mat, i, &nz, &ia, &a );
    for (j=0; j<nz; j++) {
	if (a[j] > maxv)      maxv = a[j];
	else if (a[j] < minv) minv = a[j];
	}
    }

imap[0] = imap[1] = minv - 1.0;
for (i=2; i<nc; i++) 
    imap[i] = minv + (double)(i-2) * (maxv - minv) / (nc - 2);
sr = 0; 
er = n-1;
sc = 0;
ec = n-1;
/* XBUniformHues( XBWin, nc + 2 ); */
/* Need colormap index offset ? */
XBMatrixBaseDraw( XBWin, mat, n, imap, nc, sr, er, sc, ec );
XBFlush( XBWin );
}

