#ifndef lint
static char SCCSid[] = "@(#) ./xtools/papps/qpvfp.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"               /*I "comm/comm.h" I*/
#include "xtools/basex11.h"
#include "xtools/papps/papps.h"
#include <math.h>

static void *info = 0;

/* @
   PVFPSetup - Setup a virtual front panel display
@ */
void PVFPSetup( host, nx, ny )
char *host;
int  nx, ny;
{
#if !defined(LOGCOMMDISABLE)
int    win, row;
int    wx, wy;
static XBWindow XBWin;
extern void VFPDrawForLog(), *VFPInit3();

wx = 300;
wy = 200;
if (nx <= 0 || ny <= 0) {
    nx = NUMNODES;
    ny = 1;
    }
else {
    wx = nx * 100;
    wy = ny * 100;
    }
/* I really want to open a parallel window but not a quick one */
XBPQuickWindow( &XBWin, 0, host, "pvfp", -1, -1, wx, wy, ALLPROCS );
info = VFPInit3( &XBWin, nx, ny, 0 );
VFPInitForLog( info );
PISetVFP( info, VFPDrawForLog );
#endif
}

/* issues:
   have a stack of states, so that an "undo" restores the previous state

   Need to decide on whether pix is a pixval, pixmap, or index used to
   establish what to use (should be the latter)
 */
#define WORKING   0
#define SENDING   1
#define IDLE      2
#define RECEIVING 3
#define MESSAGE   4
void VFPDoState( vfpctx, from, to, len, ev )
void *vfpctx;
int  from, to, len, ev;
{
switch (ev) {
    case LOG_RECVE:
        VFPDrawConnection( vfpctx, from, to, MESSAGE );
        VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_RECVS:
	VFPSetState( vfpctx, MYPROCID, RECEIVING );
	break;
    case LOG_RECVWE:
	VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_RECVWS:
	VFPSetState( vfpctx, MYPROCID, IDLE );
	break;
    case LOG_SENDE:
	VFPSetState( vfpctx, MYPROCID, WORKING );
	break;
    case LOG_SENDS:
	VFPSetState( vfpctx, MYPROCID, SENDING );
        VFPDrawConnection( vfpctx, from, to, MESSAGE );
	break;
    }
}
