#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"
#include "xtools/basex11.h"

#include <math.h>

#define MAX_X 64
#define MAX_Y 64

/* 
   This example should generate the same image regardless of the
   number of processors.
 */
main( argc, argv )
int argc;
char **argv;
{
int worker();
PICall( worker, argc, argv );
}

int worker( argc, argv )
int argc;
char **argv;
{
double   *mesh, *x, *y, r;
int      i, j;
int      mi, mj,         /* size of processor grid */
         li, lj;         /* location in processor grid  */
int      si, sj, ei, ej; /* local part of mesh */
int      ni, nj;         /* local size of mesh */
int      nc;             /* number of colors */
int      maxi, maxj;     /* size of global mesh */

/* Compute my location in the window */
maxi = MAX_X;
maxj = MAX_Y;
nc   = 16;

PIToMesh( &mi, &mj );
/* printf( "[%d] (%d,%d)\n", MYPROCID, mi, mj ); */
li = MYPROCID % mi;
lj = MYPROCID / mi;
ni = maxi / mi;
nj = maxj / mj;
si = li * ni;
sj = lj * nj;
ei = si + ni - 1;
ej = sj + nj - 1;
if (ei >= maxi) ei = maxi - 1;
if (ej >= maxj) ej = maxj - 1;
ni = ei - si + 1;
nj = ej - sj + 1;

mesh = (double *)MALLOC( (ni + 1) * (nj + 1) * sizeof(double) );
x    = mesh + ni * nj;
y    = x + ni;
/* Setup the data */
for (i=0; i<ni; i++) x[i] = (si+i)*(1.0/(maxi-1));
for (j=0; j<nj; j++) y[j] = (sj+j)*(1.0/(maxj-1));
for (i=0; i<ni; i++)
    for(j=0; j<nj; j++) {
        r = sqrt( (x[i] - 0.5) * (x[i] - 0.5) + (y[j] - 0.5) * (y[j] - 0.5));
        mesh[i + j * ni] = (r == 0) ? 1.0 : sin(4.0*r) / (4.0 * r);
        }

XBPQGetArgs( &argc, argv, 1 );
XBPQContour( mesh, (double *)0, (double *)0, 
	     maxi, maxj, nc, si, ei, sj, ej, ALLPROCS );
sleep(5);
}

/* convert number of processors into a mesh size.  If NUMNODES is prime, set
   mj = 1; else mi approx mj */
PIToMesh( mi, mj )
int *mi,*mj;
{
int np = NUMNODES;
int Mi, Mj, snp;

/* This is a simple try at factoring np, starting with the largest 
   choice first */
snp = (int)sqrt( (double)np + 0.01 );
while (snp > 1) {
    if ((np % snp) == 0) 
	break;
    snp--;
    }

*mi = snp;
*mj = np / snp;
}
