#ifndef LINT
static char SCCSid[] = "@(#) ./xtools/legend/legend.c 07/23/93";
#endif
/*
    This file creates a legend panel with labeled rows and columns of
    color bars.

    Legend may need to be dynamic (for such things as contour legends)
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/legend/legend.h"
#include <string.h>

/* @
     XBLegendInit - Create a legend structure
@ */
XBLegend *XBLegendInit( XBWin, font, nrows, ncols, labels, nlabels,
		        Pixels, BackPixel, bar_w, bar_h )
XBWindow *XBWin;
XBFont   *font;
int      nrows, ncols, nlabels;
char     **labels;
unsigned long   *Pixels, BackPixel;
int      bar_w, bar_h;
{
XBLegend    *legend;
int         i;
int         lxoff, ln;

legend  = NEW(XBLegend);   CHKPTRN(legend);

legend->nrows   = nrows;
legend->ncols   = ncols;
legend->labels  = (char **) MALLOC( nlabels * sizeof(char *) );  
CHKPTRN(legend->labels);
legend->nlabels = nlabels;
lxoff   = 0;
for (i = 0; i < nlabels; i++ ) {
    ln  = strlen( labels[i] );
    legend->labels[i]   = MALLOC( ln + 1 );   CHKPTRN(legend->labels[i]);
    strcpy( legend->labels[i], labels[i] );
    if (ln * font->font_w > lxoff) lxoff  = ln * font->font_w;
    }
legend->bar_h       = (bar_h < font->font_h) ? font->font_h : bar_h;
legend->bar_w       = (bar_w < lxoff) ? lxoff : bar_w;
legend->row_spacing = LEGEND_SPACING;
legend->col_spacing = LEGEND_SPACING;

legend->BackPixel   = BackPixel;
legend->Pixels      = (unsigned long *) 
             MALLOC( nlabels * sizeof(unsigned long) ); 
CHKPTRN(legend->Pixels);
for (i=0; i<nlabels; i++)
    legend->Pixels[i]   = Pixels[i];

/* This is the MINIMUM tool size */
/* 
tool->w = legend->ncols * (legend->bar_w + legend->col_spacing);
tool->h = legend->nrows * (legend->bar_h + legend->row_spacing);
 */
return legend;
}

/*
    This routine refreshes the entire panel, and may be used to do the
    initial drawing
 */
void XBLegendDraw( XBWin, font, legend )
XBWindow *XBWin;
XBFont   *font;
XBLegend *legend;
{
int    i, j, nl;
int    x, y;
PixVal white_pixel, black_pixel;

white_pixel     = XBWin->foreground;
black_pixel     = XBWin->background;
XBSetPixVal( XBWin, legend->BackPixel );
XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
                XBWin->x, XBWin->y, XBWin->w, XBWin->h );

nl  = 0;
x   = XBWin->x + legend->col_spacing;
for (j=0; j<legend->ncols; j++) {
    y   = XBWin->y + legend->row_spacing;
    if (nl >= legend->nlabels) break;
    for (i=0; i<legend->nrows; i++) {
        if (nl >= legend->nlabels) break;

        XBSetPixval( XBWin, legend->Pixels[nl] );
        XFillRectangle( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
                        x, y, legend->bar_w, legend->bar_h );
        if (legend->Pixels[nl] == black_pixel)
	    XBSetPixval( XBWin, white_pixel );
        else
	    XBSetPixval( XBWin, black_pixel );

	XBDrawText( XBWin, font, x, y - font->font_descent + legend->bar_h,
		    legend->labels[nl] );
        y   += legend->row_spacing + legend->bar_h;
        nl++;
        }
    x   += legend->col_spacing + legend->bar_w;
    }
XBFlush( XBWin );
}



/*
    Set new labels on a legend
 */
void XBLegendSetLabels( legend, labels, nlabels )
XBLegend *legend;
int      nlabels;
char     **labels;
{
int         i, ln;

if (nlabels != legend->nlabels) return;
for (i = 0; i < nlabels; i++ ) {
    ln  = strlen( labels[i] );
    FREE( legend->labels[i] );
    legend->labels[i]   = MALLOC( ln + 1 );   CHKPTR(legend->labels[i]);
    strcpy( legend->labels[i], labels[i] );
    }
}
