#ifndef lint
static char SCCSid[] = "@(#) ./xtools/axis/nice.c 07/23/93";
#endif

#include <math.h>
#define EPS 1.e-6
/* The SUN math library is more complete than most */
#ifndef sun4
static double exp10( d )
double d;
{
return pow( 10.0, d );
}
#endif

#if !defined(sun4)
/* this is a partial implmentation, adequate only for the usage here.
   The static makes it private */
static double XBfmod( x, y )
double x, y;
{
int     i;
i   = ((int) x ) / ( (int) y );
x   = x - i * y;
while (x > y) x -= y;
return x;
}

static double XBcopysign( a, b )
double a, b;
{
if (b >= 0) return a;
return -a;
}

#else
#define XBfmod     fmod
#define XBcopysign copysign
#endif

/*
    Given a value "in" and a "base", return a nice value.
    based on "sgn", extend up (+1) or down (-1)
 */
double XBAGetNice( in, base, sgn )
double  in, base;
int     sgn;
{
double  etmp;

etmp    = in / base + 0.5 + XBcopysign ( 0.5, (double) sgn );
etmp    = etmp - 0.5 + XBcopysign( 0.5, etmp ) -
		       XBcopysign ( EPS * etmp, (double) sgn );
return base * ( etmp - XBfmod( etmp, 1.0 ) );
}


/*

 */
void XBAGetBase( vmin, vmax, num, Base, power )
double  vmin, vmax, *Base;
int     num, *power;
{
double  base, ftemp;
static double base_try[5] = {10.0, 5.0, 2.0, 1.0, 0.5};
int     i;

/* labels of the form n * BASE */
/* get an approximate value for BASE */
base    = ( vmax - vmin ) / (double) (num + 1);

/* make it of form   m x 10^power,   m in [1.0, 10) */
if (base <= 0.0) {
    base    = fabs( vmin );
    if (base < 1.0) base = 1.0;
    }
ftemp   = log10( ( 1.0 + EPS ) * base );
if (ftemp < 0.0)
    ftemp   -= 1.0;
*power  = (int) ftemp;
base    = base * exp10( (double) - *power );
if (base < 1.0) base    = 1.0;
/* now reduce it to one of 1, 2, or 5 */
for (i=1; i<5; i++) {
    if (base >= base_try[i]) {
	base            = base_try[i-1] * exp10( (double) *power );
	if (i == 1) *power    = *power + 1;
	break;
	}
    }
*Base   = base;
}
