#ifndef lint
static char SCCSid[] = "@(#) ./xtools/axis/axis.c 07/23/93";
#endif

/*
   This file contains a simple routine for generating a 2-d axis.
   Given an XBWindow, it returns an XBWindow to be used be any 
   drawing routine.
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/axis/axis.h"
#include <math.h>
#define MAXSEGS 20

void XBADefTicks();
char *XBADefLabel();

#if defined(cray)
/* This is an approximation to rint for the cray */
static double rint( x )
double x;
{
if (x > 0) return floor( x + 0.5 );
return floor( x - 0.5 );
}
#endif

/*@
   XBAInitAxis - Given a window, generate the axis data structure.

   Input Parameters:
.  XBWin - X window
.  font  - font

   Note:
   This routine modifies the window so that the displayed area of the
   window is within the axis.

   This routine may change.
@*/
XBAxisData *XBAInitAxis( XBWin, font )
XBWindow *XBWin;
XBFont   *font;
{
XBAxisData *ad;
int        leftwidth, bottomheight, topheight, rightwidth;

ad            = NEW(XBAxisData);               CHKPTRV(ad,0);
ad->win       = XBWin;
ad->font      = font;
ad->xticks    = XBADefTicks;
ad->yticks    = XBADefTicks;
ad->xlabelstr = XBADefLabel;
ad->ylabelstr = XBADefLabel;

/* Set the sizes of the axis area; modify XBWin to use the
   drawing area only (???) */
leftwidth    = 10 * font->font_w;
bottomheight = 5 + font->font_h;
rightwidth   = 5;
topheight    = 5;
ad->xa = XBWin->x + leftwidth;
ad->ya = XBWin->y + topheight;
ad->wa = XBWin->w - leftwidth - rightwidth;
ad->ha = XBWin->h - bottomheight - topheight;
ad->x  = ad->xa;
ad->y  = ad->ya;
ad->h  = ad->ha;
ad->w  = ad->wa;

XBWin->x = ad->xa;
XBWin->h = ad->ha;
XBWin->w = ad->wa;
XBWin->y = ad->ya;

return ad;
}

/*@
    XBASetLimits -  Set the limits (in user coords) of the axis
    
    Input parameters:
.   ad - Axis structure
.   xmin,xmax - limits in x
.   ymin,ymax - limits in y
@*/
void XBASetLimits( ad, xmin, xmax, ymin, ymax )
XBAxisData *ad;
double     xmin, xmax, ymin, ymax;
{
ad->xlow = xmin;
ad->xhigh= xmax;
ad->ylow = ymin;
ad->yhigh= ymax;
}

/*@
    XBADrawAxis - Draw an axis.

    Input Parameter:
.   ad - Axis structure

    Note:
    This draws the actual axis.  The limits etc have already been set.
    By picking special routines for the ticks and labels, special
    effects may be generated.  These routines are part of the Axis
    structure (ad).
@*/
void XBADrawAxis( ad )
XBAxisData *ad;
{
XBWindow *awin = ad->win;
int      i, w, ntick, num, width, height;
XSegment segs[MAXSEGS];
double   sc, tickloc[MAXSEGS], sep;
char     *p;

/* Draw the axis lines.  Note that we need to reverse the y coords */
XDrawLine( awin->disp, XBDrawable(awin), awin->gc.set, 
	   ad->xa, ad->ya + ad->ha, ad->xa, ad->ya );
XDrawLine( awin->disp, XBDrawable(awin), awin->gc.set, 
	   ad->xa, ad->ya + ad->ha, ad->xa + ad->wa, ad->ya + ad->ha );

/* Draw the ticks and labels */
if (ad->xticks) {
    num = ad->wa / 100;
    if (num < 2) num = 2;
    height = -10;
    (*ad->xticks)( ad->xlow, ad->xhigh, num, &ntick, tickloc, MAXSEGS );
    sc = ad->w / (ad->xhigh - ad->xlow);
    for (i=0; i<ntick; i++) {
	segs[i].y1 = ad->ya + ad->ha;
	segs[i].y2 = ad->ya + ad->ha + height;
	segs[i].x1 = segs[i].x2 = (tickloc[i] - ad->xlow) * sc + ad->xa;
	}
    XDrawSegments( awin->disp, XBDrawable(awin), awin->gc.set, segs, ntick );
    for (i=0; i<ntick; i++) {
	if (ad->xlabelstr) {
	    if (i < ntick - 1) sep = tickloc[i+1] - tickloc[i];
	    else if (i > 0)    sep = tickloc[i]   - tickloc[i-1];
	    else               sep = 0.0;
	    p = (*ad->xlabelstr)( tickloc[i], sep );
	    w = strlen(p) * ad->font->font_w;
	    XBDrawText( awin, ad->font, 
		        segs[i].x1 - w/2, segs[i].y1 + ad->font->font_h, p );
	    }
	}
    }
if (ad->yticks) {
    num = ad->ha / 20;
    if (num < 2) num = 2;
    width = 10;
    (*ad->yticks)( ad->ylow, ad->yhigh, num, &ntick, tickloc, MAXSEGS );
    sc = ad->h / (ad->yhigh - ad->ylow);
    for (i=0; i<ntick; i++) {
	segs[i].x1 = ad->xa;
	segs[i].x2 = ad->xa + width;
	segs[i].y1 = segs[i].y2 = - (tickloc[i] - ad->ylow) * sc + 
	                          ad->ya + ad->ha;
	}
    XDrawSegments( awin->disp, XBDrawable(awin), awin->gc.set, segs, ntick );
    for (i=0; i<ntick; i++) {
	if (ad->ylabelstr) {
	    if (i < ntick - 1) sep = tickloc[i+1] - tickloc[i];
	    else if (i > 0)    sep = tickloc[i]   - tickloc[i-1];
	    else               sep = 0.0;
	    p = (*ad->ylabelstr)( tickloc[i], sep );
	    w = strlen(p) * ad->font->font_w;
	    XBDrawText( awin, ad->font, 
		        segs[i].x1 - w, segs[i].y1 + ad->font->font_h/2, p );
	    }
	}
    }
}

/*
   val is the label value.  sep is the separation to the next (or previous)
   label; this is useful in determining how many significant figures to   
   keep.
 */
char *XBADefLabel( val, sep )
double val, sep;
{
static char buf[40];
char   fmat[10];
int    w, d;

/* Find the string */
if (fabs(val) < 1.0e6) {
    /* Compute the number of digits */
    w = 0;
    d = 0;
    if (sep > 0.0) {
	d = ceil( - log10 ( sep ) );
	if (d < 0) d = 0;
	if (val == 0.0) 
	    w   = d;
	else
	    w = ceil( log10( fabs( val ) ) ) + d;
	if (w < 1)   w ++;
	if (val < 0) w ++;
	}

    if (rint(val) == val) {
	if (w > 0) 
	    sprintf( fmat, "%%%dd", w );
	else 
	    strcpy( fmat, "%d" );
	sprintf( buf, fmat, (int)val );
	}
    else {
	if (w > 0) 
	    sprintf( fmat, "%%%d.%dlf", w + 1, d );  /* Allow 1 for decimal */
	else 
	    strcpy( fmat, "%lf" );
	sprintf( buf, fmat, val );
	}
    }
else
    sprintf( buf, "%le", val );

return buf;
}

/* This is a simple routine that finds "nice" locations for the ticks */
void XBADefTicks( low, high, num, ntick, tickloc, maxtick )
double low, high, tickloc[];
int    num, *ntick, maxtick;
{
int    i;
double x, base;
int    power;
double XBAGetNice();

XBAGetBase( low, high, num, &base, &power );
x = XBAGetNice( low, base, -1 );

/* Values are of the form j * base */
/* Find the starting value */
if (x < low) x += base;

i = 0;
while (i < maxtick && x <= high) {
    tickloc[i++] = x;
    x += base;
    }
*ntick = i;

if (i < 2 && num < 10) 
    /* Try again */
    XBADefTicks( low, high, num+1, ntick, tickloc, maxtick );
}

/*@
  XBADestroyAxis - Free an axis structure

  Input Parameter:
. ad - axis structure pointer
@*/
void XBADestroyAxis( ad )
XBAxisData *ad;
{
FREE( ad );
}
