#ifndef lint
static char SCCSid[] = "@(#) ./vectors/zvec2.c 07/23/93";
#endif

/*
   These routines are for complex double precision serial vectors.
 */

#include "tools.h"
#include "system/flog.h"
#include <math.h>
#include "vectors/vector.h"       /*I "vectors/vector.h" I*/
#include "vectors/zvec.h"         /*I "vectors/zvec.h"   I*/

/*@
  ZVSetDefaultFunctions - Set vector operations for serial
  complex double precision vectors.

  Input Parameters:
.      vopP  - vector context obtained by VECreate()
 @*/
void ZVSetDefaultFunctions(vopP)
VECntx *vopP;
{
  vopP->dot    = ZVdot;
  vopP->norm   = ZVnorm;
  vopP->tdot   = ZVtdot;
  vopP->scal   = ZVscal;
  vopP->copy   = ZVcopy;
  vopP->set    = ZVset;
  vopP->axpy   = ZVaxpy;
  vopP->aypx   = ZVaypx;
  vopP->swap   = ZVswap;
  vopP->waxpy  = ZVwaxpy;
  vopP->pmult  = ZVpmult;
  vopP->pdiv   = ZVpdiv;
  vopP->obtain_vectors = ZVobtain_vectors;
  vopP->release_vectors = ZVrelease_vectors; 
  vopP->create_vector  = ZVCreateVector;
  vopP->destroy_vector = ZVDestroyVector;
}

