#ifndef lint
static char SCCSid[] = "@(#) ./vectors/pzvec.c 07/23/93";
#endif

#include "tools.h"
#include "system/flog.h"
#include <math.h>
#include "vectors/pvec.h"            /*I "vectors/pvec.h" I*/

/*
   This file contains routines for Parallel vector operations.
   Basically, these are just the local routine EXCEPT for the
   Dot products and norms.

   These are for complex double precision.
 */

/*@
   ZVPdot - Dot product for parallel complex double precision vectors.
   This is the Hermitian dot product, i.e. it uses the complex
   conjugate.

   Input Parameters:
.  N     - Vector context
.  x,y   - vectors to form dot product of

   Output Parameter:
.  z     - result
 @*/
void ZVPdot( N, x, y, z )
VEDefaultUsrCntx *N;
register dcomplex *x, *y, *z;
{
dcomplex sum, work;
ZVdot( N, x, y, &sum );
GDSUM( (double*)&sum, 2, (double*)&work, ALLPROCS );
*z = sum;
}

/*@
   ZVPtdot - Dot product for parallel complex double precision vectors.
   This is the non-Hermitian dot product, i.e. it does not use the
   complex conjugate.

   Input Parameters:
.  N     - Vector context
.  x,y   - vectors to form dot product of

   Output Parameter:
.  z     - result
 @*/
void ZVPtdot( N, x, y, z )
VEDefaultUsrCntx *N;
register dcomplex *x, *y, *z;
{
dcomplex sum, work;
ZVtdot( N, x, y, &sum );
GDSUM( (double*)&sum, 2, (double*)&work, ALLPROCS );
*z = sum;
}

/*@
   ZVPnorm - Two norm for parallel complex double precision vectors.

   Input Parameters:
.  N     - Vector context
.  x     - vector to form 2-norm of

   Output Parameter:
.  z     - result
 @*/
void ZVPnorm( N, x, z )
VEDefaultUsrCntx *N;
register dcomplex *x;
double   *z;
{
register int n = N->n, i;
double sum = 0, work;
for (i=0; i<n; i++) 
    sum += x[i].r*x[i].r + x[i].i*x[i].i;
GDSUM( (double*)&sum, 1, (double*)&work, ALLPROCS );
*z = sqrt( sum );
}

/*@
  ZVPSetDefaultFunctions - Set operations for parallel complex
  double precision vectors.

  Input parameter:
. vopP - Vector context  
 @*/
void ZVPSetDefaultFunctions( vopP )
VECntx *vopP;
{
SetZVDefaultFunctions( vopP );
vopP->dot    = ZVPdot;
vopP->norm   = ZVPnorm;
vopP->tdot   = ZVPtdot;
}
