#ifndef lint
static char SCCSid[] = "@(#) ./system/ysmp.c 07/23/93";
#endif

#include <stdio.h>

/*@
  SYndrv_error - Convert an error flag from YSMP routine ndrv to a message. 
  
  Input Parameters:
.  fp   - FILE pointer
.  flag - flag returned by ndrv
.  n    - size of system given to ndrv (needed to decode flag)
 @*/
void SYndrv_error( fp, flag, n )
FILE *fp;
int  flag, n;
{
int ver, k;

k   = ((flag-1) % n) + 1;
ver = (flag-1) / n;
switch (ver) {
    case 1: fprintf( fp, "Null row in matrix at row %d\n", k ); break;
    case 2: fprintf( fp, "Duplicate entry in matrix at row %d\n", k ); break;
    case 3: 
    case 6:
            fprintf( fp, "Insufficient storage in nsf at row %d\n", k );
            break;
    case 4: 
    case 7:
            fprintf( fp, "Insufficient storage in nnf\n" ); break;
    case 5: fprintf( fp, "Null pivot in matrix at row %d\n", k ); break;
    case 8: fprintf( fp, "Zero pivot in matrix at row %d\n", k ); break;
    case 10: fprintf( fp, "Insufficient storage in nrdv\n" ); break;
    case 11: fprintf( fp, "Illegal path spec in ndrv\n" ); break;
    default: fprintf( fp, "Unknown error %d from ndrv\n", flag ); break;
    }
}
