/*
 * USC.H  (Public header file for the Microsecond Clock package)
 *     This header file has to be included by an application using
 * the USC function calls.
 *
 * Written by:  Arun Nanda    (07/17/91)
 *
 * The following machine-specific libraries need to be linked in
 * with the application using the SYusc functions:
 *
 *      MULTIMAX      -lpp
 *      BALANCE       -lseq
 *      SYMMETRY      -lseq
 * 
 * Modified by William Gropp 08/04/92
 */

#ifndef _SYUSC_DEFS_	/* takes care of multiple inclusion of this file */
#define _SYUSC_DEFS_

/* ---------------------
 Global declarations
--------------------- */
typedef union { 
    unsigned long s1[2]; 
    double        s2;
#ifdef intelnx
    struct {long slow, shigh;}      et;
#endif
 } SYusc_time_t;

/* --------------------------------
 Machine dependent declarations
-------------------------------- */

#if defined(ATT_3B2) || defined(rs6000) \
    || defined(NeXT) || defined(TITAN) || defined(BFLY1) \
    || defined(IRIX) || defined(alliant) \
    || defined(sun3) || defined(sun4) || defined(fx2800) || defined(dec5000)
#define USEGETTIMEOFDAY
#endif

#if defined(encore)

     extern unsigned *usc_multimax_timer;

#elif (defined(balance) || defined(symmetry))

#ifndef GETUSCLK
#    include <usclkc.h>
#endif

#endif


extern unsigned long SYusc_MD_rollover_val;

/* -----------------------
 user interface macros
----------------------- */
/*M
    SYusc_clock - Gets a timer value (elapsed time) with high resolution.

    Synopsis:
    void SYusc_clock(a)
    SYusc_time_t *a;

    Input Parameter:
.   a - pointer to SYusc_time_t structure (64 bits)
M*/

#if defined(encore)

/* The Encore has a 32bit free-running timer */
#    define SYusc_clock(a) {a.s1[0]=((unsigned long) *usc_multimax_timer);}
#    define SYusc_rollover_val()  (SYusc_MD_rollover_val)

#elif (defined(balance) || defined(symmetry))

/* The Sequent has a 32bit free-running timer */
#    define SYusc_clock(a) {a->s1[0]=((unsigned long) getusclk());}
#    define SYusc_rollover_val()  (SYusc_MD_rollover_val)

#elif defined(tc2000)

/* The tc2000 has a 64 bit free-running timer */
#    define SYusc_clock(a) get64bitclock((a)->s1)
#    define SYusc_rollover_val()  0

#elif defined(intelnx)

/* The intel parallel machines has a 64 bit free-running timer */
#    define SYusc_clock(a) 	hwclock(&((a)->et))
#    define SYusc_rollover_val()  0

#elif defined(rs6000FOO)
   /* Not yet ready */
#    include <sys/time.h>
/* The rs6000 has a variety of timers */
/* Note that currently, timestruc_t is just the two fields, but we
   don't count on that */
#    define SYusc_clock(a) {timestruct_t __t;gettimer(TIMEOFDAY,&__t);\
                           (a)->s1[0] = __t.tv_sec; (a)->s1[1] = __t.tv_nsec;}
#    define SYusc_rollover_val()  0
      
#elif defined(USEGETTIMEOFDAY) || defined(cm5)

#    define SYusc_clock(a) {SYusc_MD_clock(a);}
#    define SYusc_rollover_val()  0

#else

#    define SYusc_clock(a) {(a)->s2=0.0;}
#    define SYusc_rollover_val() 0

#endif

/* ----------------------
  function prototypes
---------------------- */

void   SYusc_init();
void   SYusc_MD_clock();
double SYuscValue();
double SYuscDiff();

#endif  /* ifndef _USC_DEFS_ */
