#ifndef lint
static char SCCSid[] = "@(#) ./system/nreg.c 07/23/93";
#endif

#include <string.h>
#include <stdio.h>
#include "tools.h"
#include "system/nreg.h"      /*I "system/nreg.h" I*/
/*
   This file contains a simple system to register functions by 
   name and number
 */

/*@
  NRCreate - create a name registry

  Note:
  Use NRRegister to add names to the registry
@*/
NRList *NRCreate( )
{
NRList *fl;

fl          = NEW(NRList);     CHKPTRN(fl);
fl->head    = 0;
fl->tail    = 0;

return fl;
}

/*@
   NRRegister - Given a routine and two ids (an int and a string), 
                save that routine in the specified registry
 
   Input Parameters:
.      fl       - pointer registry
.      id       - integer (or enum) for routine
.      name     - string for routine
.      routine  - routine
@*/
void NRRegister( fl, id, name, routine )
NRList *fl;
int    id;
char   *name;
void   (*routine)();
{
FuncList *entry;

entry          = NEW(FuncList);                          CHKPTR(entry);
entry->id      = id;
entry->name    = (char *)MALLOC( strlen(name) + 1 );     CHKPTR(entry->name);
strcpy( entry->name, name );
entry->routine = routine;
entry->next = 0;
if (fl->tail)
    fl->tail->next = entry;
else
    fl->head       = entry;
fl->tail = entry;
}

/*@
    NRDestroy - Destroy a list of registered routines

    Input Parameter:
.   fl   - pointer to list
@*/
void NRDestroy( fl )
NRList *fl;
{
FuncList *entry = fl->head, *next;

while (entry) {
    next = entry->next;
    FREE( entry->name );
    FREE( entry );
    entry = next;
    }
FREE( fl );
}

/*@C
    NRFindRoutine - given an id or name, find the matching routine

    Input Parameters:
.   fl   - pointer to list
.   id   - id (-1 for ignore)
.   name - name string.  (Null for ignore)

    Returns:
    pointer to function.  Null otherwise.
@*/
void (*NRFindRoutine( fl, id, name ))()
NRList   *fl;
int      id;
char     *name;
{
FuncList *entry = fl->head;

while (entry) {
    if (id >= 0 && entry->id == id) return entry->routine;
    if (name && strcmp(name,entry->name) == 0) return entry->routine;
    entry = entry->next;
    }
return (void (*)())0;
}

/*@
    NRFindID - Given a name, find the corresponding id

    Input Parameters:
.   fl   - pointer to list
.   name - name string

    Returns:
    id.  -1 on failure.
@*/
int NRFindID( fl, name )
NRList *fl;
char   *name;
{
FuncList *entry = fl->head;

while (entry) {
    if (name && strcmp(name,entry->name) == 0) return entry->id;
    entry = entry->next;
    }
return -1;
}

/*@
    NRFindName - Given an id, find the corresponding name

    Input Parameters:
.   fl   - pointer to list
.   id   - id 

    Returns:
    Pointer to name; null on failure.
@*/
char *NRFindName( fl, id )
NRList *fl;
int    id;
{
FuncList *entry = fl->head;

while (entry) {
    if (id == entry->id) return entry->name;
    entry = entry->next;
    }
return (char *)0;
}

/*
   Return an unused index.
 */
int NRFindFreeId( fl )
NRList *fl;
{
FuncList *entry = fl->head;
int      id;

id = -1;
while (entry) {
    if (id < entry->id) id = entry->id;
    entry = entry->next;
    }
return id + 1;
}
