/* This file contains macros to log floating point operations and
   memory references */

/* D
    flog - Log floating-point operations and memory references.

    Description:
.    LOGFLOAT(n) - record that n floating point operations were performed
.    LOGLOAD(n)  - record that n loads were performed
.    LOGSTORE(n) - record that n stores were performed

.    GETLOGFLOAT(n) - set n to the number of floating point ops
.    GETLOGLOAD(n)  - ditto for loads
.    GETLOGSTORE(n) - ditto for store

    Notes:
    Define NOFLOATLOG to turn off the collection of these statistics.

    See also floatsummary() for a way to print the achieved flop and
    memory access rate for a program.

    These really aren't being used and they currently take up space.  I'm
    disabling (but not removing them) until I've decided what to do with 
    them.

D */
#ifndef LOGFLOAT

#if defined(NOFLOATLOG) || 1
#define LOGFLOAT(n)
#define LOGLOAD(n) 
#define LOGSTORE(n)
#define GETLOGFLOAT(n) n = 0
#define GETLOGLOAD(n)  n = 0
#define GETLOGSTORE(n) n = 0

#else

extern int _logfloat, _logload, _logstore;

#define LOGFLOAT(n) {_logfloat += (n);}
#define LOGLOAD(n)  {_logload  += (n);}
#define LOGSTORE(n) {_logstore += (n);}
#define GETLOGFLOAT(n) n = _logfloat
#define GETLOGLOAD(n)  n = _logload
#define GETLOGSTORE(n) n = _logstore
#endif

#endif
