#ifndef lint
static char SCCSid[] = "@(#) ./sparse/sort.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

void SpSort();
/*
   This file contains routines to permute the elements of a sparse vector 
   and matrix.
 */

/*
   Take x[i] to x[perm[i]].  
   The only complication here is that the values of the indices need
   to be sorted after the permutation is applied
 */
void SpPermuteVector( x, perm )
SpVec *x;
int          *perm;
{
int nz = x->nz, *xi = x->i;

while (nz--) {
    *xi = perm[*xi];
    xi++;
    }

/* Need to sort the values */
SpSort( x->i, x->v, x->nz );
}

/* 
   Row and column permute a matrix 
   Allow r and/or c to be null.
 */
void SpPermute( mat, r, c )
SpMat *mat;
int          *r, *c;
{
int          row, n;
SpVec **rwork;
SpRowMat *R;

SPLITTOMAT(mat);
R = GETROWMAT(mat);

n  = mat->rows;
if (c) {
    for (row=0; row<n; row++) {
	SpPermuteVector( R->rs[row], c );
	}
    }
if (r) {
    rwork = (SpVec **)SPMalloc( n * sizeof(SpVec *) ); CHKPTR(rwork);
    for (row=0; row<n; row++)
	rwork[r[row]] = R->rs[row];
    for (row=0; row<n; row++)
	R->rs[row] = rwork[row];
    SPFree( rwork );
    }
}

#define SWAP(a,b,t) {t=a;a=b;b=t;}
/* This is SLOW (n*n sort).  Could use insert/bucket sort (as used by
   factorization routines), or a quick-sort */
typedef struct { double v; int i; } SPBUF;
static int sortsize = 0;
static SPBUF *sbuf;

static int SpBufComp( i1, i2 )
SPBUF *i1, *i2;
{
return i1->i - i2->i;
}

void SpSort( i, v, n )
int    *i, n;
double *v;
{
int    tmp, j, k;
double dtmp;

/* Could use this for sort vectors */
if (n <= 10) {
    for (k=0; k<n; k++) {
	for (j=k+1; j<n; j++) {
	    if (i[k] > i[j]) {
		SWAP(i[k],i[j],tmp);
		SWAP(v[k],v[j],dtmp);
		}
	    }
	}
    }
else {
    /* 
      It is difficult to use the system sort, since the i and v are 
      separate pointers (also, the cost of a routine call for each comparison
      is high).  But we'll try it anyway, since a merge sort involves lots
      of copying anyway.  If this takes too long, we'll use merge sort
      to reduce the overhead of calling the compare routine.

      Rather than this, we could use a version of the inlined quicksort in
      system/comsort.c .
      */
    if (sortsize < n) {
	if (sortsize) FREE( sbuf );
	sbuf = (SPBUF *)MALLOC( n * sizeof(SPBUF) ); CHKPTR(sbuf);
	sortsize = n; 
	}
    for (k=0; k<n; k++) {
	sbuf[k].v = v[k];
	sbuf[k].i = i[k];
	}
    qsort( (char *)sbuf, n, sizeof(SPBUF), (int (*)())SpBufComp );
    for (k=0; k<n; k++) {
	v[k] = sbuf[k].v;
	i[k] = sbuf[k].i;
	}
    }
}

/*
    SpPermuteWithOutSort - permute the elements of a sparse vector without
    sorting them
 */    
void SpPermuteWithOutSort( x, perm )
SpVec *x;
int   *perm;
{
int nz = x->nz, *xi = x->i;

while (nz--) {
    *xi = perm[*xi];
    xi++;
    }    
}

#ifdef OLD_SORT
/* Sort just integers */
SpiIsort( n, i )
int n, *i;
{
int j, k, tmp;
if (n<8) {
  for (k=0; k<n; k++) {
    for (j=k+1; j<n; j++) {
	if (i[k] > i[j]) {
	    SWAP(i[k],i[j],tmp);
	    }
	}
    }
  }
else iqsort(i,0,n-1);
}
/* A simple version of quicksort; taken from Kernighan and Ritchie, page 87 */
int iqsort(v,left,right)
int *v,left,right;
{
  int i,last,tmp;
  if (left >= right) return 0;
  SWAP(v[left],v[(left+right)/2],tmp);
  last = left;
  for ( i=left+1; i<=right; i++ ) {
    if (v[i] < v[left] ) {last++; SWAP(v[last],v[i],tmp);}
  }
  SWAP(v[left],v[last],tmp);
  iqsort(v,left,last-1);
  iqsort(v,last+1,right);
  return 0;
}

/* Sort just doubles */
void SpiDsort( n, v )
int n;
double *v;
{
int    j, k;
double tmp;
for (k=0; k<n; k++) {
    for (j=k+1; j<n; j++) {
	if (v[k] > v[j]) {
	    SWAP(v[k],v[j],tmp);
	    }
	}
    }
}
#endif

/* 
   It would also be useful to have a sort that returns the generated 
   permutation, so that the inverse of the sorting operation could
   be performed.  This is particularly useful for algorithms that
   sort to a canonical form and need to invert the sort before 
   returning.  The easiest way to do this is to form records that
   consist of { void *data; int idx; } and to sort these records on
   data (and we can use idx to stablize the sort, since then the case
   of identical records will never arise). 
 */



