C----- SUBROUTINE QMDRCH
C***************************************************************           1.
C***************************************************************           2.
C*********     QMDRCH ..... QUOT MIN DEG REACH SET    **********           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - THIS SUBROUTINE DETERMINES THE REACHABLE SET OF            7.
C        A NODE THROUGH A GIVEN SUBSET.  THE ADJACENCY STRUCTURE           8.
C        IS ASSUMED TO BE STORED IN A QUOTIENT GRAPH FORMAT.               9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        ROOT - THE GIVEN NODE NOT IN THE SUBSET.                         12.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE PAIR.                   13.
C        DEG - THE DEGREE VECTOR.  DEG(I) LT 0 MEANS THE NODE             14.
C               BELONGS TO THE GIVEN SUBSET.                              15.
C                                                                         16.
C     OUTPUT PARAMETERS -                                                 17.
C        (RCHSZE, RCHSET) - THE REACHABLE SET.                            18.
C        (NHDSZE, NBRHD) - THE NEIGHBORHOOD SET.                          19.
C                                                                         20.
C     UPDATED PARAMETERS -                                                21.
C        MARKER - THE MARKER VECTOR FOR REACH AND NBRHD SETS.             22.
C               GT 0 MEANS THE NODE IS IN REACH SET.                      23.
C               LT 0 MEANS THE NODE HAS BEEN MERGED WITH                  24.
C               OTHERS IN THE QUOTIENT OR IT IS IN NBRHD SET.             25.
C                                                                         26.
C***************************************************************          27.
C                                                                         28.
      SUBROUTINE  QMDRCH ( ROOT, XADJ, ADJNCY, DEG, MARKER,               29.
     1                     RCHSZE, RCHSET, NHDSZE, NBRHD )                30.
C                                                                         31.
C***************************************************************          32.
C                                                                         33.
         INTEGER ADJNCY(1), DEG(1), MARKER(1),                            34.
     1           RCHSET(1), NBRHD(1)                                      35.
         INTEGER XADJ(1), I, ISTRT, ISTOP, J, JSTRT, JSTOP,               36.
     1           NABOR, NHDSZE, NODE, RCHSZE, ROOT                        37.
C                                                                         38.
C***************************************************************          39.
C                                                                         40.
C        -----------------------------------------                        41.
C        LOOP THROUGH THE NEIGHBORS OF ROOT IN THE                        42.
C        QUOTIENT GRAPH.                                                  43.
C        -----------------------------------------                        44.
         NHDSZE = 0                                                       45.
         RCHSZE = 0                                                       46.
         ISTRT = XADJ(ROOT)                                               47.
         ISTOP = XADJ(ROOT+1) - 1                                         48.
         IF ( ISTOP .LT. ISTRT )  RETURN                                  49.
            DO 600 I = ISTRT, ISTOP                                       50.
               NABOR =  ADJNCY(I)                                         51.
               IF ( NABOR .EQ. 0 ) RETURN                                 52.
               IF ( MARKER(NABOR) .NE. 0 )  GO TO 600                     53.
                  IF ( DEG(NABOR) .LT. 0 )     GO TO 200                  54.
C                    -------------------------------------                55.
C                    INCLUDE NABOR INTO THE REACHABLE SET.                56.
C                    -------------------------------------                57.
                     RCHSZE = RCHSZE + 1                                  58.
                     RCHSET(RCHSZE) = NABOR                               59.
                     MARKER(NABOR) = 1                                    60.
                     GO TO 600                                            61.
C                 -------------------------------------                   62.
C                 NABOR HAS BEEN ELIMINATED. FIND NODES                   63.
C                 REACHABLE FROM IT.                                      64.
C                 -------------------------------------                   65.
  200             MARKER(NABOR) = -1                                      66.
                  NHDSZE = NHDSZE +  1                                    67.
                  NBRHD(NHDSZE) = NABOR                                   68.
  300             JSTRT = XADJ(NABOR)                                     69.
                  JSTOP = XADJ(NABOR+1) - 1                               70.
                  DO 500 J = JSTRT, JSTOP                                 71.
                     NODE = ADJNCY(J)                                     72.
                     NABOR = - NODE                                       73.
                     IF (NODE) 300, 600, 400                              74.
  400                IF ( MARKER(NODE) .NE. 0 )  GO TO 500                75.
                        RCHSZE = RCHSZE + 1                               76.
                        RCHSET(RCHSZE) = NODE                             77.
                        MARKER(NODE) = 1                                  78.
  500             CONTINUE                                                79.
  600       CONTINUE                                                      80.
            RETURN                                                        81.
      END                                                                 82.
