C----- SUBROUTINE GEN1WD
C***************************************************************           1.
C***************************************************************           2.
C**********     GEN1WD ..... GENERAL ONE-WAY DISSECTION  *******           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - GEN1WD FINDS A ONE-WAY DISSECTION PARTITIONING             7.
C        FOR A GENERAL GRAPH.  FN1WD IS USED FOR EACH CONNECTED            8.
C        COMPONENT.                                                        9.
C                                                                         10.
C     INPUT PARAMETERS -                                                  11.
C        NEQNS - NUMBER OF EQUATIONS.                                     12.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE PAIR.                   13.
C                                                                         14.
C     OUTPUT PARAMETERS -                                                 15.
C        (NBLKS, XBLK) - THE PARTITIONING FOUND.                          16.
C        PERM - THE ONE-WAY DISSECTION ORDERING.                          17.
C                                                                         18.
C     WORKING VECTORS -                                                   19.
C        MASK - IS USED TO MARK VARIABLES THAT HAVE                       20.
C               BEEN NUMBERED DURING THE ORDERING PROCESS.                21.
C        (XLS, LS) - LEVEL STRUCTURE USED BY ROOTLS.                      22.
C                                                                         23.
C     PROGRAM SUBROUTINES -                                               24.
C        FN1WD, REVRSE, ROOTLS.                                           25.
C                                                                         26.
C***************************************************************          27.
C                                                                         28.
      SUBROUTINE  GEN1WD ( NEQNS, XADJ, ADJNCY, MASK,                     29.
     1                     NBLKS, XBLK, PERM, XLS, LS )                   30.
C                                                                         31.
C***************************************************************          32.
C                
         integer neqns
         INTEGER ADJNCY(*), LS(neqns), MASK(neqns), PERM(neqns),
     1           XBLK(neqns), XLS(neqns) 
         INTEGER XADJ(neqns+1), CCSIZE, I, J, K, LNUM, 
     1           NBLKS, NLVL, NODE, NSEP,
     1           NUM, ROOT                                                38.
C                                                                         39.
C***************************************************************          40.
C                                                                         41.
         DO 100 I = 1, NEQNS                                              42.
            MASK(I) = 1                                                   43.
  100    CONTINUE                                                         44.
         NBLKS = 0                                                        45.
         NUM   = 0                                                        46.
         DO 400 I = 1, NEQNS                                              47.
            IF ( MASK(I) .EQ. 0 )  GO TO 400                              48.
C              --------------------------------------------               49.
C              FIND A ONE-WAY DISSECTOR FOR EACH COMPONENT.               50.
C              --------------------------------------------               51.
               ROOT = I                                                   52.
               CALL  FN1WD ( ROOT, XADJ, ADJNCY, MASK,                    53.
     1                       NSEP, PERM(NUM+1), NLVL, XLS, LS )           54.
               NUM = NUM + NSEP                                           55.
               NBLKS = NBLKS + 1                                          56.
               XBLK(NBLKS) = NEQNS - NUM + 1                              57.
               CCSIZE = XLS(NLVL+1) - 1                                   58.
C              ----------------------------------------------             59.
C              NUMBER THE REMAINING NODES IN THE COMPONENT.               60.
C              EACH COMPONENT IN THE REMAINING SUBGRAPH FORMS             61.
C              A NEW BLOCK IN THE PARTITIONING.                           62.
C              ----------------------------------------------             63.
               DO 300 J = 1, CCSIZE                                       64.
                  NODE = LS(J)                                            65.
                  IF ( MASK(NODE) .EQ. 0 )  GO TO 300                     66.
                     CALL  ROOTLS ( NODE, XADJ, ADJNCY, MASK,             67.
     1                              NLVL, XLS, PERM(NUM+1) )              68.
                     LNUM = NUM + 1                                       69.
                     NUM  = NUM + XLS(NLVL+1) - 1                         70.
                     NBLKS = NBLKS + 1                                    71.
                     XBLK(NBLKS) = NEQNS - NUM + 1                        72.
                     DO 200 K = LNUM, NUM                                 73.
                        NODE = PERM(K)                                    74.
                        MASK(NODE) = 0                                    75.
  200                CONTINUE                                             76.
                     IF ( NUM .GT. NEQNS )  GO TO 500                     77.
  300          CONTINUE                                                   78.
  400    CONTINUE                                                         79.
C        ----------------------------------------------------             80.
C        SINCE DISSECTORS FOUND FIRST SHOULD BE ORDERED LAST,             81.
C        ROUTINE REVRSE IS CALLED TO ADJUST THE ORDERING                  82.
C        VECTOR, AND THE BLOCK INDEX VECTOR.                              83.
C        ----------------------------------------------------             84.
  500    CALL  REVRSE ( NEQNS, PERM )                                     85.
         CALL  REVRSE ( NBLKS, XBLK )                                     86.
         XBLK(NBLKS+1) = NEQNS + 1                                        87.
         RETURN                                                           88.
      END                                                                 89.
