/*
   This file contains some routines to test the default sparse routines.
 */
#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "fd/fd.h"

int Compare();
extern SpOps *SpDfCreateSpOps();

main( argc, argv )
int  argc;
char **argv;
{
int        i,n, m, err = 0, mx, my;
SpMat      *mat, *dfmat;
SpMatSplit *matf, *dfmatf;
double     *x, *xrow, *xdef, *b, *x2;

/* Create matrix */
mx = 3;
my = 3;

mat = FDBuildLaplacian2d( mx, my, 0.0, 0.0, 0.0 );
x   = (double *)MALLOC( mx * my * sizeof(double) );
x2  = (double *)MALLOC( mx * my * sizeof(double) );
xrow= (double *)MALLOC( mx * my * sizeof(double) );
xdef= (double *)MALLOC( mx * my * sizeof(double) );
b   = (double *)MALLOC( mx * my * sizeof(double) );

for (i=0; i<mx*my; i++) {
    x[i]  = i;
    b[i]  = i;
    x2[i] = i + mx;
    }

/* Make a copy */
dfmat = SpCopy( mat );
/* Replace the operations in dfmat */
dfmat->ops = SpDfCreateSpOps();
dfmat->ops->gathertorow     = mat->ops->gathertorow;
dfmat->ops->gatheraddtorow  = mat->ops->gatheraddtorow;
dfmat->ops->scatterfromrow  = mat->ops->scatterfromrow;
dfmat->ops->createsplit     = mat->ops->createsplit;

matf  = SpCreateSplit( mat, 0 );
dfmatf= SpCreateSplit( dfmat, 0 );

/* Perform the operations and check that the results are the same. */
SpMult( mat, x, xrow );
SpMult( dfmat, x, xdef );
err += Compare( "SpMult", mx*my, xrow, xdef );

SpMultAdd( mat, x, x2, xrow );
SpMultAdd( dfmat, x, x2, xdef );
err += Compare( "SpMultAdd", mx*my, xrow, xdef );

SpMultTrans( mat, x, xrow );
SpMultTrans( dfmat, x, xdef );
err += Compare( "SpMultTrans", mx*my, xrow, xdef );

SpComputeFill( mat, matf );
SpComputeFactor( mat, matf );

SpComputeFill( dfmat, dfmatf );
SpComputeFactor( dfmat, dfmatf );

err += CompareMatrix( matf->factor, dfmatf->factor );

SpSolve( matf, b, xrow );
SpSolve( dfmatf, b, xdef );
err += Compare( "SpSolve", mx*my, xrow, xdef );

SpSolveTrans( matf, b, xrow );
SpSolveTrans( dfmatf, b, xdef );
err += Compare( "SpSolveTrans", mx*my, xrow, xdef );

printf( "%d errors encountered\n", err );
}

int Compare( name, n, x1, x2 )
char *name;
int  n;
double *x1, *x2;
{
int i, lerr = 0;

for (i=0; i<n; i++) {
    if ( fabs( x1[i] - x2[i] ) > 1.0e-6 ) {
	fprintf( stderr, "%s: xrow[%d] = %e and xdef[%d] = %e\n", 
		 name, i, x1[i], i, x2[i] );
	lerr ++;
	}
    }
return lerr;
}

CompareMatrix( m1, m2 )
SpMat *m1, *m2;
{
int r, nr = m1->rows;
int i, *i1, *i2, nz1, nz2, err = 0;
int j1, j2;
double *v1, *v2;

for (r=0; r<nr; r++) {
    SpScatterFromRow( m1, r, &nz1, &i1, &v1 );
    SpScatterFromRow( m2, r, &nz2, &i2, &v2 );
    j1 = 0; 
    j2 = 0;
    while (j1 < nz1 && j2 < nz2) {
	if (i1[j1] < i2[j2]) {
	    if (fabs( v1[j1] ) > 1.0e-6) {
		fprintf( stderr, "[%d,%d] is %e in mat 1 and 0 in mat 2\n",
			 r, i1[j1], v1[j1] );
		err++;
		}
	    j1++;
	    }
	else if (i1[j1] > i2[j2]) {
	    if (fabs( v2[j2] ) > 1.0e-6) {
		fprintf( stderr, "[%d,%d] is %e in mat 2 and 0 in mat 1\n",
			 r, i2[j2], v2[j2] );
		err++;
		}
	    j2++;
	    }
	else {
	    if (fabs( v2[j2] - v1[j1] ) > 1.0e-6) {
		fprintf( stderr, "[%d,%d] is %e in mat 1 and %e in mat 2\n",
			 r, i2[j2], v1[j1], v2[j2] );
		err++;
		}
	    j1++;
	    j2++;
	    }
	}
    }
return err;
}
