#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/default/dfsolvet.c 07/23/93";
#endif

/*
    This file contains a simple sparse solve routine for solving the
    problem A^T x = b.  This is done by using the factors of A:
    A = LU; then A^T = U^TL^T and thus the solution is arrived at by
    solving U^T y = b followed by L^T x = y .  Because row storage is
    used for the regular factors, column storage is used for the transposes.
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"
/*
  SpDfSolveTrans - Solve a system of equations using the TRANSPOSE of
                 a factored matrix.

  Input Parameters:
.  BB - Split matrix already processed by Factor
.  b  - Right-hand-side
.  x  - solution
 */
int SpDfSolveTrans( BB, b, x )
SpMatSplit *BB;
double     *b, *x;
{
int err;
if (BB->factor->map) 
    err = 1;
else
    err = SpiDfSolveBaseTrans( BB, x, b );
return err;
}

/*
   This is a solve that does not involve any mappings 
 */
int SpiDfSolveBaseTrans( BB, x, b )
SpMatSplit  *BB;
double      *x, *b;
{
int      i, n, *nzs, rnz;
double   *v, alpha;
int      *vi, nz;
SpMat    *B = BB->factor;

n      = B->rows;
/* forward solve the lower triangular (actually the transpose of the
   upper triangular factor) */
nzs    = BB->nzl;
for (i=0; i<n; i++) {
    SpScatterFromRow( B, i, &rnz, &vi, &v );
    nz   = *nzs++;
    v    += nz;
    vi   += nz;
    nz   = rnz - nz;
    x[i] = b[i] * v[0];
    v++; vi++; nz--;
    alpha= x[i];
    SPARSEDENSESMAXPY(b,alpha,v,vi,nz);
    }

/* backward solve the upper triangular (actually the transpose of the
   lower triangular factor) */
nzs--;
for (i=n-1; i>=1; i--) {
    nz   = *nzs--;
    SpScatterFromRow( B, i, &rnz, &vi, &v );
    alpha= x[i];
    SPARSEDENSESMAXPY(x,alpha,v,vi,nz);
    }
return ERR_NONE;
}


