#ifndef lint
static char SCCSid[] = "@(#) ./sparse/addrow.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*@
    SpAddInRow - Adds a row into a sparse matrix.

    Input parameters:
.    mat   - matrix to add row to
.    row   - row index
.    n     - number of values to add
.    v     - values
.    c     - columns, these MUST be in increasing order.

    Notes:  
    By add, we mean add.  Entries will be summed into the matrix.
    Question-should values be assumed sorted?
 @*/
void SpAddInRow( mat, row, n, v, c )    
SpMat  *mat;
int    row, n, *c;
double *v;
{
SPLITTOMAT(mat);
/* Early implementation.  Better implementations could do multiple 
   inserts */
while (n--) 
    {SpAddValue( mat, *v++, row, *c++ ); CHKERR(ERR_NO_MEM);}
}

/*@
   SpAddValue - Adds to an entry in a matrix.  If the entry is not present,
                   creates it.

   Input Parameters:
.   mat - matrix to add value to 
.   val - actual value
.   i,j - row i and column j
 @*/
void SpAddValue( mat, val, i, j )
SpMat    *mat;
double   val;
int      i, j;
{
SpRowMat *R;
SpVec    *x;
int      nzx;
register int a, b, k, *ix, t;

SPLITTOMAT(mat);
R   = GETROWMAT(mat);
if (i < 0 || i >= mat->rows) {
    SETERRC( 1, "Elements out-of-range in SpAddValue" );
    return;
    }
x   = R->rs[i];
nzx = x->nz;
ix  = x->i;

/* Find location for value. */
a = 0; 
b = nzx;    /* b is one greater */
#define PRESORT
#ifdef PRESORT
while (b-a > 5) {
    t = (b+a)/2;
    if (ix[t] > j)
	b = t;
    else
	a = t;
    }
#endif
ix = ix + a;
for (k=a; k<b; k++) {
    if (*ix >= j) {
	if (*ix == j) {
	    x->v[k] += val;
	    return;
	    }
	break;
	}
    ix++;
    }
/* Insert value before the kth */
SpiInsertValue( mat, x, j, val, k );
}
