#ifndef lint
static char SCCSid[] = "@(#) ./solvers/qsregis.c 07/23/93";
#endif

/*
     Routine to register a solver with the SERIAL solver package.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include "system/nreg.h"
NRList *__SVList = 0;

/*@
   SVRegister - Given a solver name (integer)  and a function pointer;
 adds the solver to the SERIAL solver package.
 
   Input Parameters:
.      name  -  for instance SVLU, SVJacobi, ... .  If -1, a value will
                be chosen.
.      sname -  corresponding string for name
.      create - routine to create that solver
@*/
void SVRegister( name, sname, create )
int    name;
char   *sname;
void   (*create)();
{
if (!__SVList) __SVList = NRCreate();
if (name < 0) name = NRFindFreeId( __SVList );
NRRegister( __SVList, name, sname, (void (*)())create );
}
/*----------------------------------------------------------------*/
/*@
   SVRegisterDestroy - Frees the list of SERIAL iterative solvers 
  which have been registered.
@*/
void SVRegisterDestroy()
{
if (__SVList) {
    NRDestroy( __SVList );
    __SVList = 0;
    }
}

/*@
  SVGetMethod - Given the argument list, return the selected method.

  Input parameters:
. Argc - pointer to arg count
. argv - argument vector
. sname - name used to indicate solver.  If null, -svmethod is used

  Output parameter:
. svmethod -  Solver method type
@*/
void SVGetMethod( Argc, argv, sname, svmethod )
int      *Argc;
char     *argv, *sname;
SVMETHOD *svmethod;
{
char sbuf[50];

if (!sname) sname = "-svmethod";
if (SYArgGetString( Argc, argv, 1, sname, sbuf, 50 )) {
    if (!__SVList)
	SVRegisterAll();
    *svmethod = (SVMETHOD) NRFindID( __SVList, sbuf );
    }
}

/*@
    SVIsMethodAvailable - Returns a method specified by name

    Input Parameter:
.   name - name of method, such as "ilu".

    Returns:
    Value of method or -1 if method is not available.  A method may not be
    available if (a) it is a vendor/installation specific method (b) methods
    have been removed by changing SVRegisterAll.
@*/
SVMETHOD SVIsMethodAvailable( name )
char *name;
{
SVMETHOD meth;

if (!__SVList) 
    SVRegisterAll();
meth = (SVMETHOD) NRFindID( __SVList, name );
return meth;
}
