/*
   A simple no-preconditioning version.  In many cases, you should use
   Jacobi instead of this; the cost is nearly the same an the performance
   may be much better.
*/

#include "tools.h"
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include "inline/spops.h" 
#include "inline/copy.h"  

/*ARGSUSED*/
void SViCreateNoPre(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
ctx->method  = ITGMRES;
ctx->private = (void *) 0;
ctx->is_iter = 1;

ctx->setup   = SViSetupNoPre;
ctx->solve   = SViSolveNoPre;
ctx->destroy = SViDestroyNoPre;
}

void SViSetupNoPre(ctx)
SVctx *ctx;
{
double      t1;

t1 = SYGetCPUTime();
ctx->itctx = ITCreate( ctx->method );    CHKERR(1);
DVSetDefaultFunctions( ctx->itctx->vc ); CHKERR(1);
ctx->itctx->amult = SViMult;
ctx->itctx->tamult= SViMultTrans;
ctx->itctx->binv  = SViApplyNoPre;
/* put dummy values in vec_sol and vec_rhs */
ctx->itctx->vec_sol = (void *) 1;
ctx->itctx->vec_rhs = (void *) 1;
ctx->itctx->usr_monitor = 0;

ctx->nzorig      = SpNz(ctx->mat);
ctx->setupcalled = 1;
ctx->t_setup     += SYGetCPUTime() - t1;
}

int SViSolveNoPre( ctx, b, x )
SVctx  *ctx;
double *b, *x;
{
int      its;
double   t1;

if (!ctx->setupcalled) {(*ctx->setup)( ctx );  CHKERRV(1,-1);}
if (!ctx->solvecalled) {
    t1   = SYGetCPUTime();
    ITSetUp(ctx->itctx,(void *) ctx); CHKERRV(1,-1);
    ctx->t_setup += SYGetCPUTime() - t1;
    }

t1 = SYGetCPUTime();
ctx->solvecalled = 1;

SViManageInitialGuess( ctx, x );
ctx->itctx->vec_rhs = (void *)b;
ctx->itctx->vec_sol = (void *)x;
its = ITSolve( ctx->itctx, (void *)ctx );
SVGetITFlops(ctx,2*ctx->nzorig,0);
ctx->its     = its;
ctx->t_solve += SYGetCPUTime() - t1;
return its;
}

void SViDestroyNoPre( ctx )
SVctx *ctx;
{
VEDestroy( ctx->itctx->vc );
ITDestroy( ctx->itctx, ctx );
FREE( ctx );
}

void SViApplyNoPre( ctx, x, y )
SVctx  *ctx;
double *x, *y;
{
ctx->nbinv++;

DVcopy( &(ctx->size), x, y );
}

