/* Private include file for some iterative methods      */
/* This file should not be included in any application code */

/* Define the "global" symbols used by the macros */
#ifndef IT
#define IT i
#endif
#ifndef USRP
#define USRP usrP
#endif

#define EOUC(u,error,str,IT) {u;CHKERRV(error,-((IT)+1));}

#define DOT(x,y,val)        VDOT(itP->vc,USRP,x,y,val) 
#define NORM(x,val)         VNORM(itP->vc,USRP,x,val)
#define CONVERGED(rnorm,it) (cerr=(*itP->converged)(itP,USRP,it,rnorm))
#define RCONV(it)           ((cerr>0)?it:-it)
#define MM(x,y)             EOUC(PMM(x,y),1000,"User amult",IT);
#define MTM(x,y)            EOUC(PMTM(x,y),1000,"User tamult",IT);
#define PRE(x,y)            EOUC(PPRE(x,y),1001,"User binv",IT);
#define COPY(x,y)           EOUC(PCOPY(x,y),1002,"User mcopy",IT);
#define SCALE(alpha,x)      EOUC(PSCALE(alpha,x),1003,"User mscal",IT);
#define SET(alpha,x)        EOUC(PSET(alpha,x),1004,"User mset",IT);
#define DAXPY(alpha,x,y)    EOUC(PDAXPY(alpha,x,y),1005,"User maxpy",IT);
#define DAYPX(alpha,x,y)    if (itP->vc->aypx) {                             \
                              EOUC(PDAYPX(alpha,x,y),1006,"User maypx",IT);  \
                            }                                                \
                            else {                                           \
                              SCALE(alpha,y);                                \
                              DAXPY(1.0,x,y);                                \
                            }
#define DWAXPY(alpha,x,y,w)    if (itP->vc->waxpy) {                         \
                           EOUC(PDWAXPY(alpha,x,y,w),1006,"User mwaypx",IT);  \
                            }                                                \
                            else {                                           \
                              COPY(w,y);                                    \
                              DAXPY(alpha,x,y);                              \
                            }
#define MATOP(x,y,temp)     if (itP->matop) {                                \
	                      EOUC(PMATOP(x,y),1007,"User matop",IT);        \
			    }                                                \
                            else {                                           \
			      if (itP->right_inv) {                          \
				 PRE(x,temp);MM(temp,y);}                    \
			      else {                                         \
				 MM(x,temp);PRE(temp,y);}                    \
                              }
#define MONITOR(rnorm,it)   if (itP->usr_monitor) {                          \
                            EOUC(PMONITOR(rnorm,it),1008,"User monitor",it);  \
                            }

/* ---- These macros are used only by those above, not in the code  ------ */

#define PMM(x,y)            (*itP->amult)(USRP,x,y) 
#define PMTM(x,y)           (*itP->tamult)(USRP,x,y) 
#define PPRE(x,y)           (*itP->binv)(USRP,x,y) 
#define PMATOP(x,y)         (*itP->matop)(USRP,x,y)
#define PCOPY(x,y)          VCOPY(itP->vc,USRP,x,y) 
#define PSCALE(alpha,x)     VSCALE(itP->vc,USRP,alpha,x) 
#define PSET(alpha,x)       VSET(itP->vc,USRP,alpha,x) 
#define PDAXPY(alpha,x,y)   VAXPY(itP->vc,USRP,alpha,x,y) 
#define PDWAXPY(alpha,x,y,w) VWAXPY(itP->vc,USRP,alpha,x,y,w) 
#define PDAYPX(alpha,x,y)   VAYPX(itP->vc,USRP,alpha,x,y) 
#define PNORM(x,val)        VNORM(itP->vc,USRP,x,val)
#define PMONITOR(rnorm,it)  (*itP->usr_monitor)(itP,USRP,it,rnorm)

#if !defined(MAX)
#define  MAX(a,b)           ((a) > (b) ? (a) : (b))
#endif


