#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "solvers/svctx.h"
#include "fd/fd.h"
#include "vectors/dvec.h"

/*
    Example program using IFFlowOrder to compute alternate approximate
    factorizations based on the prevailing "flow" direction for a simple
    convection/diffusion problem
 */

double vx, vy;
double bx( x, y )
{
return vx;
}
double by( x, y )
{
return vy;
}

int main( argc, argv )
int  argc;
char **argv;    
{
int    nx, ny, has_circle, *nxn, *sn, *order, *iorder, i, j, n, ns, loc, 
       no_order;
SpMat  *mat;
double *x, *b;
int    its;
SVctx  *svctx;
/* We'll eventually need a version that tries IFFlow2d as well */

if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s [-nx n] [-ny n ] [-vx f] [-vy f] [-circle]\n",
	     argv[0] );
    return 0;
    }

/* Set defaults */
vx = 1.0;
vy = 1.0;
nx = 21;
ny = 21;
nx = 3;
ny = 3;
has_circle = 0;
SYArgGetDouble( &argc, argv, 1, "-vx", &vx );
SYArgGetDouble( &argc, argv, 1, "-vy", &vy );
has_circle = SYArgHasName( &argc, argv, 1, "-circle" );
SYArgGetInt( &argc, argv, 1, "-nx", &nx );
SYArgGetInt( &argc, argv, 1, "-ny", &ny );
no_order = SYArgHasName( &argc, argv, 1, "-noorder" );

/* We should actually try this with a matrix that becomes triangular when 
   ordered */
mat = FDBuildFDElliptic2dBndySub( (double (*)())0, (double (*)())0, bx, by, 
				  (double (*)())0, nx, ny, 0.0, 0.0, 1.0, 
				   0, nx-1, 0, ny-1 );
if (!no_order) {
    /* Compute "next nodes" and "start nodes", depending on flow type, along 
       with the matrix */
    nxn   = (int *)MALLOC( nx * ny * sizeof(int) );    CHKPTRV(nxn,1);
    sn    = (int *)MALLOC( (nx + ny) * sizeof(int) );  CHKPTRV(sn,2);
    order = (int *)MALLOC( nx * ny * sizeof(int) );    CHKPTRV(order,3);
    iorder= (int *)MALLOC( nx * ny * sizeof(int) );    CHKPTRV(iorder,4);
    if (has_circle) {
	/* Starting nodes */
	/* Next nodes */
	}
    else {
	ns = 0;
	/* Starting nodes (bottom and left side) */
	for (i=0; i<nx; i++) sn[ns++] = i;
	for (i=1; i<ny; i++) sn[ns++] = i * nx;
	/* Next nodes */
	n = nx * ny;
	for (i=0; i<n; i++) nxn[i] = -1;
	for (j=0; j<ny-1; j++) {
	    for (i=0; i<nx-1; i++) {
		loc      = i + j * nx;
		nxn[loc] = loc + 1 + nx;
		}
	    }
	}
    
    IFFlowOrder( nx * ny, nxn, sn, ns, order );
    CHKERR(1);    

    n = nx * ny;
    for (i=0; i<n; i++) 
	fprintf( stdout, "%d ", order[i] );
    fprintf( stdout, "\n" );

    
    /* Need to do this in the context of SV... */
    SpSetMappingPtrs( mat, order, order, iorder );
    }

n     = nx * ny;
x     = DVCreateVector( &n );
b     = DVCreateVector( &n );
for (i=0; i<n; i++) 
    x[i] = 1.0;
SpMult( mat, x, b );

svctx = SVCreate( mat, SVILU );
SVSetUp( svctx );
its = SVSolve( svctx, b, x );
SVDestroy( svctx );

fprintf( stderr, "Iterations = %d\n", its );
{ double sum = 0.0;
  for (i=0; i<n; i++) sum += (x[i] - 1.0) * (x[i] - 1.0);
fprintf( stderr, "Error is = %f\n", sqrt(sum) );
  }

return 0;
}

#ifdef FOO
/* It would be nice to have a routine to dump the ordering out assuming a 
   grid */

cnt = 0;
for (j=0; j<ny; j++) {
    for (i=0; i<nx; i++) {
	if (order[cnt] >= 0) {
	    compute next node from order[cnt]
	    draw from here to there 
	    }
	cnt++;
	}
    }
#endif
