#ifndef lint
static char SCCSid[] = "@(#) ./comm/pgcomm/pgcomm.c 07/23/93";
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "tools.h"
#include "comm/pgcomm/pgcomm.h"

/* Get PGComm from file ; there should also be a version to get this
   data from the command line */
PGCommAll *PGFileToList( fname )
char *fname;
{
FILE      *fp;
int       nhost;
PGCommAll *new;

fp = fopen( fname, "r" );
if (!fp) {
    SETERRC( 1, "Could not open procgroup file" );
    return 0;
    }

/* Get the number of entries */
nhost = PGNum( fp );

/* Generate them */
new = NEW(PGCommAll);         CHKPTRN(new);
new->nhost = nhost;
new->hosts = (PGComm *)MALLOC( nhost * sizeof(PGComm) ); CHKPTRN(new->hosts);

/* Read in the data */
fseek( fp, 0L, 0 );
PGReadFile( fp, new );

return new;
}

/* Get PGComm from a string (contains ONLY the host names) */
PGCommAll *PGStringToList( str )
char *str;
{
int       i, nhost;
PGCommAll *new;
PGComm    *host;
char      *p, *p1;

/* Get the number of entries */
p     = str;
nhost = 0;
while (p) {
    p = strchr( p, ',' );
    nhost ++;
    if (p) p++;
    }

/* Generate them */
new = NEW(PGCommAll);         CHKPTRN(new);
new->nhost = nhost;
new->hosts = (PGComm *)MALLOC( nhost * sizeof(PGComm) ); CHKPTRN(new->hosts);

p          = str;
host       = new->hosts;
new->nhost = nhost;
for (i=0; i<nhost; i++) {
    p1 = strchr( p, ',' );
    if (p1) 
	*p1 = 0;
    strncpy( host->host.name, p, MAXHOSTNAMELEN - 1 );
    host->host.np   = 1;
    host->host.arch = -1;
    host->host.nice = 0;
    host->host.next = 0;
    host->wd        = 0;
    host->exe       = 0;
    
    p = p1 + 1;
    host++;
    }

return new;
}

/* Return the number of hosts in the file and -1 on error */
int PGNum( fp )
FILE *fp;
{
char machine[128];
/*char exe[1024];
char wd[1024]; */
int  nhost = 0;
int  c;

while (1) {
    if (fscanf( fp, "%s", machine ) < 0) {
	return nhost;
	}
    if (machine[0] != '#') nhost++;
    while ((c = getc( fp )) != '\n' && c != EOF) ;
    }
}

/* Get a string.  Return 0 on success; -1 on failure */
int PGGetString( fp, str )
FILE *fp;
char *str;
{
int c;
char *p;

str[0] = 0;
/* Skip blanks */
while ((c = getc(fp)) != EOF && isspace(c) && c != '\n') ;
if (c == '\n') return -1;
if (c != EOF) ungetc( c, fp );

p = str;
while ((c = getc(fp)) != EOF && !isspace(c)) *p++ = c;
if (c == EOF) return -1;
else          ungetc( c, fp );
*p = '\0';

/* if (str[0]) printf( "|%s|\n", str ); */
return str[0] ? 0 : -1;
}

/* Read in the file */
int PGReadFile( fp, pg )
FILE      *fp;
PGCommAll *pg;
{
PGComm  *host;
char machine[128];
char exe[1024];
char wd[1024];
char arch[20];
char buf[1024], *p;
int  np;
int  c;

host = pg->hosts;

while (1) {
    if (PGGetString( fp, machine )) 
	break;
    if (machine[0] == '#') {
	while ((c = getc( fp )) != '\n' && c != EOF) ;
	}
    /* read strings until we get the end-of-line */
    exe[0]  = 0;
    wd[0]   = 0;
    arch[0] = 0;
    np      = 1;
    while (1) {
	if (PGGetString( fp, buf )) break;
	
	/* look for known names (exe=, arch=, np=, wd=) */
	if (p = strchr( buf, '=')) {
	    *p = '\0';
	    if (strcmp( "exe", buf ) == 0) 
		strcpy( exe, p + 1 );
	    else if (strcmp( "arch", buf ) == 0) 
		strcpy( arch, p + 1 );
	    else if (strcmp( "np", buf ) == 0)
		np = atoi( p + 1 );
	    else if (strcmp( "wd", buf ) == 0)
		strcpy( wd, p + 1 );
	    else {
		char buf2[1024];
		sprintf( buf2, "Unknown option %s", buf );
		SETERRC( 1, buf2 );
		}
	    }
	else {
	    /* if it is a string, it is the exe= field; if it is a number,
	       it is the np= field */
	    p = buf;
	    while (*p) {
		if (!isdigit(*p)) break;
		p++;
		}
	    if (*p)  {
		if (machine[0])
		    strcpy( exe, buf );
		else 
		    strcpy( machine, buf );
		}
	    else     np = atoi( buf );
	    }
	}
    /* Set the fields */
    if (machine[0]) {
	strncpy( host->host.name, machine, MAXHOSTNAMELEN );
	}
    else 
	host->host.name[0] = 0;
    
    if (exe[0]) {
	host->exe = (char *)MALLOC( strlen(exe) + 1 );  CHKPTR(host->exe);
	strcpy( host->exe, exe );
	}
    else host->exe = 0;
    if (wd[0]) {
	host->wd = (char *)MALLOC( strlen(wd) + 1 );  CHKPTR(host->wd);
	strcpy( host->wd, wd );
	}
    else host->wd = 0;
    if (arch[0]) {
	host->host.arch = PIStringToArch( arch );
	}
    else host->host.arch = -1;
    host->host.np = np;
    host++;
    }
}

/* recover the space for a PG structure */
void PGDestroy( pg )
PGCommAll *pg;
{
int     nhost;
PGComm  *host;

nhost = pg->nhost;
host  = pg->hosts;

while(nhost--) {
    if (host->exe)
	FREE( host->exe );
    if (host->wd)
	FREE( host->wd );
    host++;
    }
FREE( pg->hosts );
FREE( pg );
}

void PGPrintList( pg, fp )
PGCommAll *pg;
FILE      *fp;
{
int    nhost = pg->nhost;
PGComm *host = pg->hosts;

while (nhost--) {
    fprintf( fp, "%s %d", host->host.name, host->host.np );
    if (host->exe)
	fprintf( fp, " exe=%s", host->exe );
    if (host->host.arch) {
	char arch[100];
	PIArchToString( arch, host->host.arch );
	fprintf( fp, " arch=%s", arch );
	}
    fprintf( fp, "\n" );
    host ++;
    }
}

/* 
   This routine forms "standard" host tables from a generic list

   utable - final table
   table  - table of available machines
   bname, path, cwd - used to get the default executable name
 */
void PGtoHostTables( pg, Utable, Table,
		     bname, path, cwd )
PGCommAll *pg;
HostTable **Utable, **Table;
char      *path, *bname, *cwd;
{
Host      *head, *last, *list;
int       i;
HostTable *table, *utable, *PICopyHostTable();
Arch      arch, defArch;
char      archname[40];
char      *defPgm;

table = NEW(HostTable); CHKPTR(table);
*Table = table;
MEMSET(table,0,sizeof(HostTable));

SYGetArchType( archname, 40 );
defArch = PIStringToArch( archname );

/* Build a list, using the host fields, and
   Determine the number of nodes and the number in each architecture.
   If the architecture is unspecified, then the default architecture (that
   of the initial process) is used */
/* Note that we must allocate NEW Host fields so that the table code can
   properly delete them */
head = last = 0;
for (i=0; i<pg->nhost; i++) {
    pg->hosts[i].host.next  = &pg->hosts[i+1].host;
    list      = NEW(Host);   CHKPTR(list);
    *list     = pg->hosts[i].host;
    if (head) last->next = list;
    else      head       = list; 
    last      = list;
    table->np += pg->hosts[i].host.np;
    arch      =  pg->hosts[i].host.arch;
    if ((int)arch < 0) {
	pg->hosts[i].host.arch = arch = defArch;
	list->arch                    = defArch;
	arch                          = defArch;
	}
    table->archtable[(int)arch].fname = pg->hosts[i].exe;
    table->archtable[(int)arch].ne++;
    table->archtable[(int)arch].np += pg->hosts[i].host.np;
    }
pg->hosts[pg->nhost-1].host.next = 0;

PIiCopyHostsToTable( table, pg->nhost, head );
table->ne = pg->nhost;
table->na = PIiAddToArchList( table, head, MAXARCHES );
table->np = pg->nhost;  /* Should be np */

/* Add the executables */
for (i=0; i<MAXARCHES; i++) {
    if (table->archtable[i].ne > 0 && !table->archtable[i].fname) {
	defPgm = PIExecutableName( bname, (char *)0, path, cwd, i, i );
	table->archtable[i].fname = (char *)MALLOC( strlen(defPgm) + 1 );
	CHKPTR(table->archtable[i].fname);
	strcpy( table->archtable[i].fname, defPgm );
	FREE( defPgm );
	}
    }

/* Table is a table of all available hosts; utable is the table of 
   ones to use.  In the case of an explicit host list, we use them all
   (at least for now...) */
*Utable = /* utable = */ PICopyHostTable( table );
}
