#ifndef lint
static char SCCSid[] = "@(#) ./comm/htable/bhost.c 07/23/93";
#endif

#include <stdio.h>
#include <time.h>
#if !defined(__MSDOS__)
#include <sys/param.h>
#endif

#ifdef ipsc2
#include <sys/types.h>
#endif

/* 
  From sys/param.h:
 x #define	MAXPATHLEN	1024
 x #define	MAXHOSTNAMELEN  64
 */
#ifndef MAXPATHLEN
#define MAXPATHLEN 1024
#endif
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#include "tools.h"
#include "comm/htable/bhost.h"

void SYFindHost();
/* For debugging */
static int dbg = 0;

/* 
   This file contains routines to search a database of possible hosts 
   for a distributed program and identifies potential hosts.  

   Notes:
   The method is to search the table for machines that have the
   correct architecture and are available for running a program
   with the requested resource values (programs which need more
   resources are prohibited; this makes them more friendly on 
   a distributed cluster of workstations).

   The process is basically to look at each entry and see if the entry
   is acceptable or not.  The rules are (in this order):
   
$   if (architecture does not match)    reject
$   if (owner DOES match)               accept
$   if (timeofday does not match)       reject
$   if (cpulimit  does not match)       reject
$   if (memlimit  does not match)       reject
$   if (pagefaultlimits does not match) reject

   On an accept, 
$  if machine is a multiprocessor, take as many processors as needed.
$  skip through machines with the same name (note that a machine many
   be mentioned several times in the hosts file, once for each limit
   category.  Typically, there are entries for different times of day).
   
 */

typedef struct {
    char name[129];
    char arch[129], owner[12];
    int  hs, ms, he, me;
    char day[12];
    int  mem, cpu, pf, np, niceval, htype[4];
    } HOSTDATA;
    
/*+
    PIBuildHostList - Build a list of available machines from a "standard"
    file of available machines.

    Input parameters:
.    np     - number of desired processors
.    fin    - file pointer to file with description
.    fout   - file pointer to output file
.    arch   - architecture of running program
.    pgm    - full name of program; possibly with %a for arch
.    mem    - amount of memory that the program may use
.    tim    - amount of time that the program may use
.    Dbg    - if 1, generate debugging output (explain why machines were
              rejected or accepted).
.    plist  - pointer to array of size at least np (if you are looking
              for workstations) into which the list of hosts will be placed.

The format of the file is
$ hostname architecture owner hs:ms-he:me days memory time pagefaults nproc nice
$ (%s       %s          %s    %d %d %d %d %s   %d    %d   %d         %d     %d
$ Days are of the form daystart-dayend.  The value of days is
$   M - Monday
$   Tu- Tuesday
$   W - Wednesday
$   Th- Thursday
$   F - Friday
$   S - Saturday
$   Su- Sunday.
$ There may be no spaces in the specification.
+*/    
int PIBuildHostList( np, fin, arch, mem, cpu, pfaults, Dbg, plist )
int    np;
FILE   *fin;
char   *arch;
int    mem, cpu, pfaults, Dbg;
HOSTEntry *plist;
{
int    hh, mm, err;
char   daystart, dayend;
char   owner[12];
char   localhost[MAXHOSTNAMELEN];
char   lastname[MAXHOSTNAMELEN];
char   *datestr;
int    dayofweek;
time_t timer;
struct tm *tm;
HOSTDATA hinfo;
int    num;

dbg = Dbg;

/* Should initially skip to my local hostname, and continue from there */
/* gethostname( localhost, MAXHOSTNAMELEN ); */
/* SYFindHost( fin, localhost ); */

SYGetUserName( owner, 12 );

/* We'd also like to get the hostname so that the "local" node won't 
   be repeated */

/* Get the time */
timer     = time( 0 );
tm        = localtime( &timer );
hh        = tm->tm_hour;
mm        = tm->tm_min;
/* Use datestr to determine the day-of-the-week */
datestr   = ctime( &timer );
dayofweek = PIConvertSysDay( datestr );

strcpy( lastname, "??" );
num = 0;
while (np > 0) {
    if (!PIiReadHosts( fin, &hinfo )) break;
    if (strcmp( lastname, hinfo.name ) == 0) continue;
    if (PIiTestArch( arch, &hinfo, dbg )) continue;
    if (PIiTestOwner( owner, &hinfo, dbg )) {
	PIiaccept( plist, np, &hinfo );
	np -= hinfo.np;
	plist++;
	num ++;
	/* Skip machines with the same name */
	strcpy( lastname, hinfo.name );
	continue;
	}
    if (PIiTestLim( mem, hinfo.mem,    "mem", &hinfo, dbg )) continue;
    if (PIiTestLim( cpu, hinfo.cpu,    "cpu", &hinfo, dbg )) continue;
    if (PIiTestLim( pfaults, hinfo.pf, "Page faults", &hinfo, dbg )) continue;
    if (PIiTestDay( datestr, dayofweek, &hinfo, dbg )) continue;
    if (PIiTestTime( hh, mm, &hinfo, dbg )) continue;
    PIiaccept( plist, np, &hinfo );
    np -= hinfo.np;
    plist++;
    num ++;
    strcpy( lastname, hinfo.name );
    }

return num;
}

PIiaccept( plist, np, hinfo )
HOSTEntry *plist;
int      np;
HOSTDATA *hinfo;
{
int nnp = hinfo->np;
if (nnp > np) nnp = np;
plist->name = MALLOC( strlen(hinfo->name) + 1 );     CHKPTR(plist->name);
strcpy( plist->name, hinfo->name );
plist->np = nnp;
plist->niceval = hinfo->niceval;
}

int PIiTestArch( arch, hinfo, dbug )
char     *arch;
HOSTDATA *hinfo;
int      dbug;
{
if (arch) {
    if (strcmp(arch,hinfo->arch) != 0) {
	if (dbug || dbg) 
	    fprintf( stdout, "Rejected %s for wrong arch (%s != %s)\n",
		     hinfo->name, hinfo->arch, arch );
	return 1;
	}
    }
/* We might also want to see if the indicated version of the software is
   available by doing a stat on the appropriate file */
return 0;
}

int PIiTestOwner( owner, hinfo, dbug )
char     *owner;
HOSTDATA *hinfo;
int      dbug;
{
if (strcmp(hinfo->owner, owner) == 0) {
    if (dbug || dbg) 
	fprintf( stdout, "Accepted %s for %s == %s\n", 
		 hinfo->name, owner, hinfo->owner );
    return 1;
    }
return 0;
}

int PIiTestLim( lm, hlm, str, hinfo, dbug )
int  lm, hlm, dbug;
HOSTDATA *hinfo;
char *str;
{
if (lm && hlm && lm > hlm) {
    if (dbug || dbg)
	fprintf( stdout, 
		 "Rejected %s for exceeding %s (%d > %d)\n", 
		 hinfo->name, str, lm, hlm );
    return 1;
    }
return 0;
}

int PIiTestDay( datestr, dayofweek, hinfo, dbug )
char     *datestr;
int      dayofweek, dbug;
HOSTDATA *hinfo;
{
int hostdws, hostdwe;

/* Check the day of the week */
hostdws = PIConvertSysDay( hinfo->day );
hostdwe = PIConvertSysDay( strchr( hinfo->day, '-' ) + 1 );
if (dayofweek < hostdws || dayofweek > hostdwe) {
    datestr[3] = '\0';
    if (dbug || dbg) 
	fprintf( stdout, "Rejected %s for day of week: %s not in %s\n",
		 hinfo->name, datestr, hinfo->day );
    return 1;
    }
return 0;
}

int PIiTestTime( hh, mm, hinfo, dbug )
int      hh, mm, dbug;
HOSTDATA *hinfo;
{
int he, me, hs, ms;

he = hinfo->he;
me = hinfo->me;
hs = hinfo->hs;
ms = hinfo->ms;
/* Time-of-day requirements.  This is a little tricky, since we want
   to allow specs like 18:00-08:00 */
/* Check day first */
if (timege(he,me,hs,ms)) {
    if (timege(hs,ms,hh,mm) || timege( hh,mm,he,me )) {
	if (dbug || dbg) {
	    fprintf( stdout, "Rejected %s for time of day: %d:%d not in ",
		    hinfo->name, hh, mm );
	    fprintf( stdout, "%d:%d-%d:%d\n", hs, ms, he, me );
	    }
	return 1;
	}
    }
else {
    if (timege(hh,mm,he,me) && timege( hs,ms,hh,mm)) {
	if (dbug || dbg) {
	    fprintf( stdout, "Rejected %s for time of day: %d:%d not in ",
		    hinfo->name, hh, mm );
	    fprintf( stdout, "%d:%d-%d:%d\n", hs, ms, he, me );
	    }
	return 1;
	}
    }
return 0;
}

/* return 1 if the first time is greater than the second, 0 otherwise.
   Handle wrapping at midnight */
int timege(h1,m1,h2,m2)
int h1,m1,h2,m2;
{
if (h1 > h2) return 1;
if (h1 == h2 && m1 >= m2) return 1;
return 0;
}

/* 
   Convert the day in system format (Mon, Tue, Wed, Thu, Fri Sat Sun)
   to the range 0 - 6
 */
PIConvertSysDay( d )
char *d;
{
if (d[0] == 'M') return 0;
if (d[0] == 'W') return 2;
if (d[0] == 'F') return 4;
if (d[0] == 'T') {
    if (d[1] == 'h') return 3;
    else             return 1;
    }
if (d[0] == 'S') {
    if (d[1] == 'u') return 6;
    else             return 5;
    }
return -1;
}

void SYFindHost( fin, localhost )
FILE *fin;
char *localhost;
{
int err;
char hostname[MAXHOSTNAMELEN];

while (1) {
    err = fscanf( fin, "%s", hostname );
    while (fgetc( fin ) != '\n') ;
    if (err == 1 && hostname[0] == '#') {
	continue;
	}
    if (err < 0) {
	/* We've exhausted the list */
	return;
	}

    if (strcmp( hostname, localhost ) == 0) {
	/* Found; now skip until we see a NEW host */
	while (1) {
	    err = fscanf( fin, "%s", hostname );
	    while (fgetc( fin ) != '\n') ;
	    if (err < 0) break;
	    if (strcmp( hostname, localhost ) != 0) break;
	    }
	return;
	}
    }
}


/* Read a record from the host file.  Return 1 on success, 0 on failure (like
   EOF) */
int PIiReadHosts( fin, hinfo )
FILE     *fin;
HOSTDATA *hinfo;
{
int   err;

while (1) {
    err = fscanf( fin, "%s", hinfo->name );
    if (err == 1 && hinfo->name[0] == '#') {
	/* Skip to end of line */
	while (fgetc( fin ) != '\n') ;
	continue;
	}
    err = fscanf( fin, "%s %s %d:%d-%d:%d %s %d %d %d %d %d %s\n",
		 hinfo->arch, hinfo->owner,
		 &hinfo->hs, &hinfo->ms, &hinfo->he, &hinfo->me, hinfo->day, 
		 &hinfo->mem, &hinfo->cpu, &hinfo->pf, &hinfo->np, 
		 &hinfo->niceval, hinfo->htype );
    if (err != 13)
	return 0;
    hinfo->cpu = 60 * (hinfo->cpu);   /* Change to seconds */
    if (dbg) 
	fprintf( stdout, "%s %s %s %d:%d-%d:%d %s %d %d %d %d %d %s\n",
		 hinfo->name, hinfo->arch, hinfo->owner,
		 hinfo->hs, hinfo->ms, hinfo->he, hinfo->me, hinfo->day, 
		 hinfo->mem, hinfo->cpu, hinfo->pf, hinfo->np, 
		 hinfo->niceval, hinfo->htype );
    break;
    }
return 1;
}

/* 
   Build a program name given the base string and the architecture

   Input:
.  pgm - name of program
.  arch - architecture

   Output:
.  pgmname - full name of program   
 */
PIBuildPgmName( pgm, arch, pgmname )
char *pgm, *arch, *pgmname;
{
char *p;
char temp[257];

strcpy( pgmname, pgm );
/* look for %a */
p = pgmname;
while (*p) {
    if (*p == '%' && p[1] == 'a') {
    	strcpy( temp, p+2 );
    	strcpy( p, arch );
    	strcat( p, temp );
        }
    else p++;
    }
}
