#ifndef lint
static char SCCSid[] = "@(#) ./comm/global/gtoken.c 07/23/93";
#endif

#include "comm/comm.h"
#include "comm/global/global.h"

static int _gtokdata = 0;

/*
   This is a special "token" routine.  A common use of GSYNC is:

   for (i=0;i<NUMNODES;i++) {if (i==MYPROCID) <do-something>; GSYNC(procset);}

   This is rather expensive when all we are doing is passing a handle around
   saying "you-can-go-next".  We replace this with

   for (i=0;i<=NUMNODES;i++) {if (gtoken(procset,i)) <do-something>;}

   Note that the loop must be executed one additional time.
 */
int gtokenset( procset, i )
ProcSet *procset;
int     i;
{
int right, left, root, myid, np;
int msgbase;

LOGOPSTART(LOG_GTOKS);
LOGPUSHATOMIC;
/* printf( "[%d] doing gtoken\n", MYPROCID ); */
if (!procset) {
    myid    = MYPROCID;
    np      = NUMNODES;
    left    = (myid == 0) ? np-1 : myid - 1;
    right   = myid + 1;
    if (right >= np) right = 0;
    root    = 0;
    }
else {
    myid  = procset->myid;
    np    = procset->nump;
    right = procset->right;
    left  = procset->left;
    root  = procset->root;
    }
msgbase = GMSGTYPE(procset,0);

/* These aren't quite right for the general case (need the relative index 
   of MYPROCID in the ring/mesh */
if (i == myid && myid != root) {
    RECVSYNCNOMEM(msgbase|left,&_gtokdata,sizeof(int),MSG_INT);
    }
else if ((i-1) == myid) {
    SENDSYNCNOMEM(msgbase|myid,&_gtokdata,sizeof(int),right,MSG_INT);
    }
else if (myid == root && i == np) {
    RECVSYNCNOMEM(msgbase|left,&_gtokdata,sizeof(int),MSG_INT);
    }
LOGOPEND(LOG_GTOKE);
LOGPOPATOMIC;
return (i == myid);
}

/*
    These two routines allow the user to get/set the token that is
    passed around
 */
void PISetToken( val )
int val;
{
_gtokdata = val;
}

int PIGetToken()
{
return _gtokdata;
}	
