c This is the front-end calling program to run the parallel version of Salman's
c code.  From here, control is passed on to piex (Salman's original code).

      program main
      external piex
c
c      print*, 'Staring pi program'
      call picall(piex, -1, 0)
      end


      subroutine piex()
c$$$
c$$$  Declarations for parallel implementation
c$$$

      Integer           nprocs, myid, pinumtids, pimytid
      Integer           PSCreate
      Integer           procset0, name, i

      Integer           MSG_DBL, MSG_INT
      Integer           dblsze, intsze
      Parameter (MSG_DBL = 4, MSG_INT = 1)
      Parameter (dblsze = 8, intsze = 4)

      double precision  pi, pi25dt, h, sum, x, f, a, temp
      integer intsiz
      integer n, i
      parameter(PI25DT = 3.141592653589793238462643d0)
      parameter(INTSIZ=4)

c --  function to intergrate

      f(a) = 4.d0 / (1.d0 + a*a)

      nprocs = PInumtids()
      myid   = PImytid()

c$$$
c$$$  Create a processor set and add all processors to it
c$$$

      name = 5
      procset0 = PSCreate(name)
      do i = 0, nprocs-1
         Call PSAddMember(procset0, i, 1)
      end do
      Call PSCompile(procset0)

10    if ( myid .eq. 0 ) then
         write(6,98)
98       format('Enter the number of intervals: (0 quits)')
         read(5,99)n
99       format(i10)
      endif

      Call PIbcastSrc(n , intsze, 0, procset0, MSG_INT)

c --  everyone check for quit signal

      if ( n .le. 0 ) goto 30

c --  calculate the interval size

      h = 1.0d0/n

      sum  = 0.0d0
      do 20 i = myid+1, n, nprocs
         x   = h * (dble(i) - 0.5d0)
         sum = sum + f(x)
20    continue
      pi = h * sum

c --  collect all the partial sums

      call PIgdsum(pi, 1, temp, procset0)

c --  node 0 prints the answer.

      if (myid .eq. 0) then
         write(6, 97) pi, abs(pi - PI25DT)
      endif
      goto 10

97    format('  pi is approximately: ', F18.16,'  Error is: ', F18.16)

30    continue
      return
      end
