/*
    These are the definitions particular to the pvm implementation.
 */

#ifndef __commpvm3
#define __commpvm3

#ifndef __commh
#include "comm/comm.h"
#endif

extern int __PVMFROM, __PVMLEN, __PVMTYPE, __PVMGLOBALTYPE;

#define MSG_INT   0
#define MSG_LNG   1
#define MSG_FLT   2
#define MSG_DBL   3
#define MSG_OTHER 4
#define MSG_SHRT  5

#define NO_ASYNC_SEND
#define NO_ASYNC_RECV
#define NO_FORCE
#define NO_NATIVE_GLOBAL

#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	Cpvm_send(type,to,(int*)(buffer),length,datatype);LOGSENDEND(type);}
#define RECVSYNC(type,buffer,length,datatype) { \
        __PVMFROM = -1;__PVMTYPE = type; __PVMLEN = length;LOGRECVSTART(type);\
        Cpvm_recv(&__PVMTYPE,&__PVMFROM,(int*)(buffer),&__PVMLEN,datatype); \
        LOGRECVEND(type,__PVMLEN,__PVMFROM);}
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
/* Note: if the buffer was smaller than the received message, we should
   generate an error */
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype)
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
      	__PVMFROM = -1;__PVMTYPE = type; __PVMLEN = size; LOGRECVSTART(type);\
       Cpvm_recv_unsz(&__PVMTYPE,&__PVMFROM,(int**)&(bufp),&__PVMLEN,datatype);\
        LOGRECVEND(type,size,__PVMFROM);}

#define SYNCPROBE(type) {while(Cpvm_probe(type)==-1);}
#define ASYNCPROBE(type) (Cpvm_probe(type) != -1)

/* I'm not sure that this is correct */
#define RECVPROBED(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)

#define RECVLEN()  __PVMLEN
#define RECVFROM() __PVMFROM
#define RECVTYPE() __PVMTYPE

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)

#define NUMNODES __NUMNODES
#define MYPROCID __MYPROCID

/* The max value below is approximate */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=10000000;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGSIZES(min,max)      {*min=0;*max=(16384*8096);}
#define MSGDIAMETER            (NUMNODES-1)

#endif

