#ifndef lint
static char SCCSid[] = "@(#) ./comm/basename.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/hosts.h"     /*I "comm/hosts.h" I*/
#include <stdio.h>
#include <string.h>

/*+
   PIBaseName - Given a filename, which may contain various indications
          of the architecture; this returns the base name. 

   Input parameters:
.   name   - entire name 
.   format - not yet supported
.   maxlen - length of name

   Output parameters:
.   bname - base part of name


+*/
void PIBaseName(name,format,bname,maxlen)
char *bname, *format,*name;
int  maxlen;
{
  char *tmp2, *tmp;
  int  len;

  /* first remove all parts of the path. */
  tmp2 = (tmp2 = strrchr(name,'/')) ? tmp2 + 1 : name;

  if (format) {
    SETERRC(1,"Format not yet supported");
  }
  else { /* we default to the simple name.arch format */
    tmp = strrchr(tmp2,'.');
    if (!tmp) {
      strcpy(bname,tmp2);
    }
    else {
      /* determine length of substring */
      len = strlen(tmp2) - strlen(tmp);
      strncpy(bname,tmp2,len);
      bname[len] = 0;
    }
  }
}

/*+
   PIFullPathFromBase - Given a basename, this returns the complete 
     filename for a particular architecture, the file is guarented
     to exist and be executable. 

   Input parameters:
.   filename   - name 
.   arch - name of architecture
.   format - not yet used 
.   path - path to search through, not yet supported

+*/
int PIFullPathFromBase( bname, arch, format, path, name, maxlen, cwd )
char *bname,*format,*name,*path,*cwd;
int  maxlen;
Arch arch;
{
  int  len;
  char tmp[MAXPATHLEN],tmp2[MAXPATHLEN],archstring[20];

  if (format) {
      /* name is given by format, with %a replaced with the architecture
	 and %n the bname */
    SETERRC(1,"Format not yet supported");
    return 0;
  }
  else {
    if (arch > -1 ) {
      PIArchToString(archstring,arch);
      len = strlen(bname) + strlen(archstring) + 2;
      strcpy(tmp,bname);
      strcat(tmp,".");
      strcat(tmp,archstring);
    }
    else {
      strcpy(tmp,bname);
    }
  }

  strcpy(tmp2,cwd); len = strlen(tmp2); 
  if ( tmp2[len] != '/' ) strcat(tmp2,"/");
  strcat(tmp2,tmp);

  /* now search path for file */
  return SYGetFileFromPath( path, tmp2, tmp, name, 'e' );
}

