

/* 
   This file contains a test program for the routines that generate
   BC programs for global arrays with a variety of decompositions 
 */

#include "tools.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include <stdio.h>

/*ARGSUSED*/
int main( argc, argv )
int  argc;
char **argv;
{
int         i, nd, myid, nproc;
BCArrayPart sz[8];
BCPGM       *pgm;

/* Define the array */
nd = 3;
sz[0].mdim        = 10;
sz[0].is_parallel = 1;
sz[0].ndim        = -1;
sz[1].mdim        = 11;
sz[1].is_parallel = 0;
sz[1].ndim        = -1;
sz[2].mdim        = 6;
sz[2].is_parallel = 1;
sz[2].ndim        = -1;

/* Setup the ghost points from the stencil */
BCFindGhostFromStencil( nd, sz, 0, (int *)0, 11 );
nproc = 4;
fprintf( stdout, "Decomposition is:\n" );
for (myid = 0; myid < nproc; myid++) {
    fprintf( stdout, "For processor %d:\n", myid );
    for (i=0; i<nd; i++) sz[i].ndim = -1;
    BCGlobalToLocalArray( nd, sz, nproc, myid );
    BCPrintArrayPart( stdout, nd, sz );
    pgm = BCBuildArrayPGM( nd, sz, nproc, myid, sizeof(double) );
    BCprint_pgms( pgm, stdout );
    BCfree( pgm );
    }
return 0;
}
