/* @(#) ./blkcm/mesh.h 07/23/93 */

#ifndef __MESH
#define __MESH
/* 
   This include contains data for the MESH versions of the block communications
   code 
 */

#define BC_NORTH 1
#define BC_SOUTH 2
#define BC_EAST  3
#define BC_WEST  4
#define BC_SOUTHWEST 5
#define BC_SOUTHEAST 6
#define BC_NORTHWEST 7
#define BC_NORTHEAST 8
#define BC_CENTER 0

/* These are old and are being phased out ... */
/* Map of processor layout */
typedef struct {
    int nx, ny, i, j, *map;
    } BCProcMap;

typedef struct {
    int si, sj, ei, ej, mx, my;
    } BCArrayLimits;
/* ... to here */

typedef struct {
    int mdim,               /* size of array in this dimension */
        is_parallel,        /* true if the array is parallelized in this
			       dimension */
        start,              /* starting index for local piece */
        end,                /* ending index for local piece */
        loc;                /* location in this dimension of the processor */
    int ndim;               /* number of processors in this dimension; -1
			       if unspecified */
    int sg, eg;             /* start and end ghost limits */
    int nsg, neg;           /* neighbor start and end ghost limits */
    } BCArrayPart;

typedef struct {
    int         start, end, incr;
    } BCRange;
/* A c-grid is described with the mapping of points (s1-e2),
   the dimension that the mapping is along (edgedim), the
   dimension that is NORMAL to the edge (normaldim).  The other dimensions
   are numbered naturally.  Finally, there is normalidx, which is that 
   value of the index (either 0 or m-1) where the edge that is "wrapped"
   is */
typedef struct {
    int         edgedim,            /* dimension that wraps */
                normalidx;          /* index (0 or mdim-1) */
    int         normaldim;          /* dimension that is inverted */
    int         s1, e1, s2, e2;     /* s1:e1:1 -> s2:*:-1 */
    } BCCgridDesc;
        
BCPGM     *BCBuildMesh();
BCProcMap *BCBuildProcMap();
BCPGM     *BCBuildArrayPGM();
BCPGM     *BCBuildCgridPGM();

void BCAddToArrayPGM( );
void BCArrayCompile( );
void BCFindGhostFromStencil( );
void BCSetGhostWidths( );
void BCPrintArrayPart( );
void BCGlobalToLocalArray( );

#endif
