#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/exec/server.c 07/23/93";
#endif

/*
   This file contains a generic producer/consumer routine.  The idea is that
   in a distributed data structure, a computation consists of generating
   rvalues, operating on them, and modifying an lvalue.  
   Naturally, for maximum efficiency, these values should be large
   aggregate objects (such as vectors).

   An rvalue is a src, and has a destination ids associated with it
   (target lvalue).  An lvalue is a dest, and has an id. 
   A computation is formed as:
   
   while (n=src(n,&buffer,&size,&ids,&nids)) 
       for (i=0; i<nids; i++) deliver(buffer,size,ids[i]);
   while (not_terminated(r)) {
       accept(&buffer,&size,&id);
       dest(&r,buffer,size,id);
       }
   
   where "dest" may generate additional "src" calls (handled the same way).

   Rule:  dests happen anytime after the src is generated; in particular,
   a local src may perform its operation immediately.  Usually, such
   operations will be done within the src or dest routine using purely local
   operations.

   Example: a parallel matrix factorization routine.  
   Data structure:  One or more blocks of rows, identified by the lead
   row.

   src-routine:
   
   dest-routine:
       input: a block of pivot rows and the number of the lead row.
       possible sends: blocks of pivot rows when all possible input
       rows have been received.  These may be sent to one or more 
       processors (pattern agreed to in advance), using the src routine.

   The USER needs a routine that can be called to do sending (so that
   it may be called from the consumer).
       
 */
#ifdef FOO
#include "tools.h"
#include "blkcm/bc.h"
#include "blkcm/bcp.h"

int BCactive( first, context, incr, action )
void *first, (*incr)(), *context, (*action)();
{
do {
    /* Look for incoming */
    if (msg_in_buffer) {
	get msg;
	match data;
	check for termination;
	}
    /* continue to process */
    (*action)( first, context );
    first = (*incr)( first );
    }
}
	   
int BCnactive( first, context, incr, action, nmsgs )
void *first, (*incr)(), *context, (*action)();
int  nmsgs;
{
while (nmsgs--) {
    RECVSYNCNOMEM( MSG_TYPE, buf, buflen, MSG_DBL );
    (*action)( buf, context );
    }
}

/*
   A common need is to do the following:
   send a series of messages
   recv a series of messages and act on them

   Routines are provides to form up the messages to send and to handle
   messages received.  The routines are passed a context that may be
   used by the programmer.
 */
int BCsr( nsend, sendact, scontext,
	     nrecv, recvact, rcontext, outbuflen )
int (*sendact)(), nsend, outbuflen, (*recvact)();
void *scontext, *rcontext;
{
int  sbuflen, sproc;
char *sbuf, *outbuf;

MSGALLOCRECV( outbuf, outbuflen, char );
/* Send the messages */
while (nsend--) {
    (*sendact)( &scontext, &sbuf, &sbuflen, &sproc );
    SENDSYNCNOMEM( VALID_TYPE, sbuf, sbuflen, sproc, MSG_DBL );
    }
/* Receive the messages */
while (nrecv--) {
    RECVSYNC( VALID_TYPE, outbuf, outbuflen, MSG_DBL );
    (*recvact)( outbuf, &rcontext );
    }
MSGFREERECV( outbuf );
}   

#endif
