#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/defn/option.c 07/23/93";
#endif

#include "blkcm/bcp.h"
#include "blkcm/bc.h"

typedef double *(*dblfunc)();
/* 
   This file contains routines to set the option functions
 */

/*@
   BCset_option - Set an option value on a program.

   Input Parameters:
.  Program - program to set
.  optionname - option.  One of
$  BCOPTION_BUFFER - buffer multiple sends to the same processor
$  BCOPTION_PAIRSYNC - optimize for exchanges between pairs of processors
$  BCOPTION_NOAUTOTYPE - alternate routine for message types
$  BCOPTION_NOVALID    - alternate routine for validation
$  BCOPTION_NOSORT     - alternate routine for ordering program
$  BCOPTION_INPLACE    - alternate routine to find in-place buffers
$  BCOPTION_TRIMMOVE   - alternate routine to condense copy operations
$  BCOPTION_NOFINDOWNER - alternate routine to determine "owners"
$  BCOPTION_SRCADDRESS  - alternate routine to compute source address
$  BCOPTION_DESTADDRESS - alternate routine to compute destination address
.  routine - routine to use to implement option.

   Note:
   This routine is really for experts and for people using canned routines.
   Each option is implemented as a routine call; using a NULL routine 
   will disable the option (but may also be invalid).   
@*/
void BCset_option( Program, optionname, routine )
BCPGM *Program;
int   optionname;
int   (*routine)();
{
switch (optionname) {
    case BCOPTION_BUFFER:      Program->buffer   = routine; break;
    case BCOPTION_PAIRSYNC:    Program->pairsync = routine; break;
    case BCOPTION_NOAUTOTYPE:  Program->settypes = routine; break;
    case BCOPTION_NOVALID:     Program->valid    = routine; break;
    case BCOPTION_NOSORT:      Program->sort     = routine; break;
    case BCOPTION_INPLACE:     Program->inplace  = routine; break;
    case BCOPTION_TRIMMOVE:    Program->trimmove = routine; break;
    case BCOPTION_NOFINDOWNER: Program->findowner= routine; break;
    case BCOPTION_SRCADDRESS:  Program->GetAddressSrc  = (dblfunc) routine; 
                               break;
    case BCOPTION_DESTADDRESS: Program->GetAddressDest = (dblfunc) routine; 
                               break;
    }
}
