#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util2d.c 07/23/93";
#endif

/* 
    This file contains routines for moving data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */

#include "tools.h"
#include "blkcm/bcp.h"

BCs_to_d2d( s, d )
slab *s, *d;
{
register double *sp1 = s->p;
register double *dp1 = d->p;
register double *sp, *dp;
register int    n2, n1, dinc = d->s1, sinc = s->s1;

n2 = s->n2;
while (n2--) {
    n1 = s->n1;
    dp = dp1;
    sp = sp1;
    while (n1--) {
	*dp = *sp;
	dp  += dinc;
	sp  += sinc;
	}
    dp1 += d->inc1;
    sp1 += s->inc1;
    }
}

BCs_to_b2d( s, b )
slab   *s;
double *b;
{
register double *sp1 = s->p;
register double *dp = b;
register double *sp;
register int    n2, n1, spinc = s->s1;

n2 = s->n2;
while (n2--) {
    n1 = s->n1;
    sp = sp1;
    while (n1--) {
	*dp++ = *sp;
	sp  += spinc;
	}
    sp1 += s->inc1;
    }
}


BCb_to_d2d( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp1 = d->p;
register double *dp;
register int    n2, n1, dpinc = d->s1;

n2 = d->n2;
while (n2--) {
    n1 = d->n1;
    dp = dp1;
    while (n1--) {
	*dp = *sp++;
	dp  += dpinc;
	}
    dp1 += d->inc1;
    }
}

#include "blkcm/bc.h"
/* 
   Routine to set the entries for a line for a 2-d structure
 */
BCset2d( Program, line, id, phase, kind, p, n1, n2, s1, inc1 )
BCPGM *Program;
int   line, id, phase, kind, n1, n2, s1, inc1;
void  *p;
{
BCentry *pgm;

pgm = (*Program->getline)( Program, line );
if (!pgm) return ERR_NO_PGM_LINE;

pgm->id       = id;
pgm->phase    = phase;
pgm->type     = kind;
pgm->processor= -1;
pgm->src.s1   = s1;
pgm->src.n1   = n1;
pgm->src.n2   = n2;
pgm->src.n3   = 1;
pgm->src.n4   = 1;
pgm->src.n5   = 1;
pgm->src.inc1 = inc1;
pgm->src.inc2 = 1;
pgm->src.inc3 = 1;
pgm->src.inc4 = 1;
pgm->src.lctx = p;

BCSetMaxdim( Program, n1, n2, 1, 1, 1 );
return ERR_NONE;
}
