#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#ifndef NOUNISTD_H
#include <unistd.h>
#endif
#include <signal.h>

#include "fudgit.h"
#include "macro.h"
#include "head.h"
#include "setshow.h"

int Ft_Interact = 0;
char *Ft_Progname;
static int initload(void);

void main(int c, char **v)
{
    /****
    mallopt(M_DEBUG, 1);
    mallopt(M_MXFAST, 0);
    ******/
    Ft_initmac();
    Ft_initstacks();  /* don't fool around with the order */
    Ft_initparser();
    Ft_initmacros();
    Ft_initcode();
    Ft_initsetup();
	Ft_initdl();
    Ft_clearpush_cwd();
    signal(SIGPIPE, SIG_IGN);
    signal(SIGFPE, Ft_catcher);
    signal(SIGINT, Ft_catcher);
    signal(SIGQUIT, Ft_catcher);
    signal(SIGTSTP, Ft_catcher);
#ifdef SIGBUS
    signal(SIGBUS, Ft_catcher);
#endif
    signal(SIGHUP, Ft_catcher);
    signal(SIGSEGV, Ft_catcher);
    signal(SIGILL, Ft_catcher);
    Ft_Interact = isatty(0);
	Ft_Progname = v[0];

    if (c == 1 && Ft_Interact) {
        initload();
        Ft_initreadline();
		Ft_printversion();
        Ft_run();
    }
    else {
        int i;

        Ft_Interact = 0;
        if (c==1) {
            initload();
            Ft_run();
        }
        else {
            for (i=c-1;i>0;i--) {  /* push all the files on the I/O stack */
                Ft_pushio(v[i], AFILE, 0);
            }
            initload();
            Ft_run();
        }
    }
    Ft_exit(0);
}

#include <sys/types.h>
#include <sys/stat.h>

static int initload(void)
{
    char name[TOKENSIZE];
    struct stat buf;

    sprintf(name, "%s/.fudgitrc", Ft_Home);
    if (stat(name, &buf) == 0)
        return(Ft_pushio(name, AFILE, 0));

    return(0);
}

int Ft_printversion(void)
{
    fprintf(stderr, "\n\tF U D G I T\n\tversion  %s\n\tMay 1993\n",
	VERSION);
    fprintf(stderr, "\tlast modified %s\n", DATE);
    fputs("\tCopyright (C) 1993  Martin-D. Lacasse\n", stderr);
    fputs("\tSee the `Credits' and `README' help topics for more.\n\n", stderr);
	return(0);
}
