/*--------------------------------------------------------------------------
 Definitions for the vector RPN calculator stack object.
--------------------------------------------------------------------------*/
#ifndef stack_h
#define stack_h
/* @(#)stack.h	1.1 7/15/91 */

#include "sig.h"

#define STACK_MAX 1000	/* max # of signals on stack */

typedef struct {
    sig_t *sigs[STACK_MAX];	/* stack of signals.  sigs[0] is TOS. */
    int   n;			/* number of signals in stack */
} stack_t;

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* stack.c */
void stack_show _ARGS_((stack_t *this));
void stack_push _ARGS_((stack_t *this, sig_t *sig));
sig_t *stack_pop _ARGS_((stack_t *this, int i));
sig_t *stack_peek _ARGS_((stack_t *this, int i));
void stack_xchg _ARGS_((stack_t *this, int i));
void stack_cat_y _ARGS_((stack_t *this, int n));

#undef _ARGS_
#endif

