/*--------------------------------------------------------------------------
 Definitions for signals, which are 2-d arrays of complex numbers.
--------------------------------------------------------------------------*/
#ifndef sig_h
#define sig_h
/* @(#)sig.h	1.1 7/15/91 */

#include "hdr.h"

#define SIG_MAXFNAME 1024

typedef struct {
    int  nrec;			/* # of records */
    int  reclen;		/* # of elements per record */
    int  kind;			/* see hdr.h */

    short *re;			/* real part */
    short *im;			/* imaginary part */
    short *exp;	/* if kind&hdr_KIND_BFP, holds each record's exponent. */
    char fname[SIG_MAXFNAME];	/* filename, if from file, else blank */
} sig_t;

/* Number of bytes per atomic element.  This times reclen gives size
 * in bytes of each record of im or re.
 */
#define sig_ELBYTES(this) (this->kind & hdr_KIND_BYTES)

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* sig.c */
sig_t *sig_new _ARGS_((int nrec, int reclen, int kind, char *fname));
sig_t *sig_copy _ARGS_((sig_t *this));
void sig_destroy _ARGS_((sig_t *this));
void sig_complex _ARGS_((sig_t *this));
void sig_real _ARGS_((sig_t *this));
void sig_verify _ARGS_((sig_t *this));
void sig_fprint _ARGS_((sig_t *this, int nrec_p, int nel_p, struct _iobuf *fp));

#undef _ARGS_
#endif

