/*
 * plot(3) clone. Implements the commands described in the the V7 UNIX 
 * manual pages and produces a standard UNIX plotfile. 
 *
 * The resulting plotfile is to be used with the plot(1) command.
 *
 * Author: Wietse Venema (wietse@wzv.UUCP)
 *
 * Changed to support output to arbitrary FILE * by dan kegel 
 * (dank@blacks.jpl.nasa.gov): 
 */

#include <stdio.h>

/* Enable this section if on a sparc or other machine that stores ints MSB-first.
 * Sun's -lplot outputs ints in same byte order as on Vaxen, i.e. LSB-first,
 * even though it's the reverse of the native byte order.
 */
short swiz_short;
#ifdef sparc
#define sb(i,n) ((i>>n) & 255)
#define swiz(i) ((sb(i,0)<<8)|(sb(i,8)<<0))
#define swiza(i) ((swiz_short = swiz(i)), &swiz_short)
#else
#define swiza(i) ((swiz_short = i), &swiz_short)
#endif


/* some shorthands... */


#define	fWrite(fp, x)			fwrite((char *) swiza(x), sizeof(short), 1, fp)
#define	fWrite2(fp, a,b)		fWrite(fp, a); fWrite(fp, b)
#define	fWrite3(fp, a,b,c)		fWrite2(fp, a,b); fWrite(fp, c)
#define	fWrite4(fp, a,b,c,d)		fWrite2(fp, a,b); fWrite2(fp, c,d)
#define	fWrite6(fp, a,b,c,d,e,f)	fWrite4(fp, a,b,c,d); fWrite2(fp, e,f)

pl_open(fp)
FILE *fp;
{
#ifndef unix
    you may have to select binary mode for fp
#endif
}

pl_move(fp, x, y)
FILE *fp;
{
    putc('m', fp);
    fWrite2(fp, x, y);
}

pl_cont(fp, x, y)
FILE *fp;
{
    putc('n', fp);
    fWrite2(fp, x, y);
}

pl_point(fp, x, y)
FILE *fp;
{
    putc('p', fp);
    fWrite2(fp, x, y);
}

pl_line(fp, x1, y1, x2, y2)
FILE *fp;
{
    putc('l', fp);
    fWrite4(fp, x1, y1, x2, y2);
}

pl_label(fp, s)
FILE *fp;
char *s;
{
    putc('t', fp);
    fputs(s, fp);
    putc('\n', fp);
    /* Library used to append a NULL, but man page claims it should be newline
     * terminated.
     */
}

pl_arc(fp, x, y, x0, y0, x1, y1)
FILE *fp;
{
    putc('a', fp);
    fWrite6(fp, x, y, x0, y0, x1, y1);
}

pl_circle(fp, x, y, r)
FILE *fp;
{
    putc('c', fp);
    fWrite3(fp, x, y, r);
}

pl_erase(fp)
FILE *fp;
{
    putc('e', fp);
}

pl_linemod(fp, s)
FILE *fp;
char *s;
{
    putc('f', fp);
    fputs(s, fp);
    putc('\n', fp);
}

pl_space(fp, x0, y0, x1, y1)
FILE *fp;
{
    putc('s', fp);
    fWrite4(fp, x0, y0, x1, y1);
}

pl_close(fp)
FILE *fp;
{
    fflush(fp);
}
