#ifndef hdr_h
#define hdr_h
/* @(#)hdr.h	1.2 8/2/91 */

/*--------------------------------------------------------------------------
 File header type for vector data.
 Byte ordering is that of the Sun4.
 Header is extensible; new fields can be added without breaking old
 software, because length of header is stored in header.
 Note: bytes/element indicates size of real componant for complex types.

 Block floating point is handled as follows:
 each record is preceded by a 16-bit 2's complement exponant.  A block
 floating point record with a zero exponant has the same value
 as a non-block-floating-point integer record; an exponant of 1 means
 the data must be shifted left once to yield their true value.

 To let Unix's file command know about this header type, add the following 
 lines to /etc/magic:
0       short           0x2750          vector data,
>4      long            x0              %d records,
>8      long            x0              %d elements/record,
>15     byte            x0              %d bytes/scalar,
>14     byte            0               integer
>14     byte            1               float
>14     byte            2               integer complex
>14     byte            3               float complex
>14     byte            4               block floating point 
>14     byte            6               block floating point complex
--------------------------------------------------------------------------*/
#define hdr_MAGIC 0x2750	/* first 2 bytes of header always same */

#define hdr_KIND_BYTES	 (15<<0)	/* bit mask */

#define hdr_KIND_1BYTE	 (1<<0)
#define hdr_KIND_2BYTE	 (2<<0)
#define hdr_KIND_4BYTE 	 (4<<0)
#define hdr_KIND_8BYTE 	 (8<<0)
#define hdr_KIND_FLOAT   (1<<8)
#define hdr_KIND_COMPLEX (2<<8)
#define hdr_KIND_BFP     (4<<8)	/* block floating point */

/* Shorthand for useful combinations of above */
#define hdr_INT8	hdr_KIND_1BYTE
#define hdr_CINT8	(hdr_KIND_1BYTE|hdr_KIND_COMPLEX)
#define hdr_INT16	hdr_KIND_2BYTE
#define hdr_CINT16	(hdr_KIND_2BYTE|hdr_KIND_COMPLEX)
#define hdr_BFP16	(hdr_KIND_2BYTE|hdr_KIND_BFP)
#define hdr_CBFP16	(hdr_KIND_2BYTE|hdr_KIND_BFP|hdr_KIND_COMPLEX)
#define hdr_FLOAT32	(hdr_KIND_4BYTE|hdr_KIND_FLOAT)
#define hdr_CFLOAT32	(hdr_KIND_4BYTE|hdr_KIND_FLOAT|hdr_KIND_COMPLEX)

typedef struct {
    short magic;		/* constant ID tag */
    short hdrlen;		/* sizeof(hdr_t); offset of 1st data byte */
    int   nrec;			/* number of records in file */
    int   reclen;		/* number of elements in record */
    int   kind;			/* some logical OR of hdr_KIND_* */
} hdr_t;

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* hdr.c */
void hdr_read _ARGS_((struct _iobuf *fp, hdr_t *hdr, char *msg));
void hdr_write _ARGS_((struct _iobuf *fp, int nrec, int reclen, int kind));
void hdr_kind2a _ARGS_((int kind, char *buf));

#undef _ARGS_
#endif
