# Usage: m4 filename | drpn
# Demonstrate phase recovery via integer range compression 

verbose 0
echo @(#)demo_rc_phase.m4	1.1 7/23/91

define(RESAMP,8)
// RANGELEN is # of samples in range line
// LOG_RANGELEN is log base 2 of # of samples in range line
// warning: fft fails (due to lack of precision?) at log_rangelen >= 15
define(LOG_RANGELEN,12)
define(RANGELEN,eval(2^LOG_RANGELEN))
define(RANGECLEN,eval(RANGELEN/2))
// CHIRPLEN is # of samples in ac_chirp before padding
define(CHIRPLEN,225)
// ARGMAX is sample # of peak of range-compressed echo
define(ARGMAX,eval(((RANGELEN-CHIRPLEN+1)*RESAMP)/2))
// NEAR is how many samples to plot in vicinity of ARGMAX
define(NEAR,eval(RANGELEN/64))
echo rangelen=RANGELEN

#----------------------------------------------------------
# usage: scale_it factor
macro scale_it 
float32
real $1
cvt_complex
float32
xchg 1
mult
end
#
#----------------------------------------------------------
macro generate_data
# generate simulated echo pulse; pad with zeroes & scale it down.
# Chose chirp phase to vary phase of result from pi to -pi
// Illustrate starting chirp phase.  Be sure to match this with ac_chirp lines.
    real 3.14 1.56 0 -1.56 -3.14
    name starting_phase_of_echo,x=echo#
    plot_r 0 0 2
    pop
ac_chirp 5e-6 20e6 1.25e6 -3.14 5e6 45e6
ac_chirp 5e-6 20e6 1.25e6 -1.56 5e6 45e6
ac_chirp 5e-6 20e6 1.25e6 0.00  5e6 45e6
ac_chirp 5e-6 20e6 1.25e6 1.56  5e6 45e6
ac_chirp 5e-6 20e6 1.25e6 3.14 5e6 45e6
# the 5 chirps are now 5 signals; make them a single signal with 5 records.
cat_y 5
# pad out to RANGELEN
pad_x 0 eval(RANGELEN-CHIRPLEN)
# Convert to int8, offset-binary, in range -127..127
cvt_real
real 127
float32
xchg 1
mult
int8
real 128
int8
xchg 1
add
end

#----------------------------------------------------------
# usage: make_chirp
macro make_chirp
# Create time-reversed chirp
# ac_chirp chirp_time, chirp_freq_range, f_0, nu_slow, nu_fast
# AIRSAR reference manual section 3.2.1 gives chirp_time as 5 or 10 uSec,
# nu_slow (aka frequency update rate) as 5 MHz.
ac_chirp 5e-6 20e6 1.25e6 0 5e6 45e6
reverse_x
end
#
#----------------------------------------------------------
# Uses m4 constants RANGELEN, CHIRPLEN
# Usage: rc type scale s1..s5
#            $1   $2   $3 $4 $5 $6 $7 
# Example: range_compress bfp16    2048 1 1 1 1 1
# Example: range_compress float32 0.125 1 1 1 1 1
#
# use conjugated positive frequencies instead of negative frequencies
# AND use conjugate/fft/conjugate instead of inverse fft
macro range_compress

make_chirp
# pad to range line length, take FFT, discard positive frequencies
pad_x 0 eval(RANGELEN-CHIRPLEN)
fft_dif
cconjugate
delete_x 0 RANGECLEN
scale_it $2
$1			# (computation type)

# Grab input data, convert real-offset-binary-bytes to computation type
xchg 1			# Move input data to top of stack.
real -128
int8
xchg 1
add
cvt_complex
$1			# (computation type)

# take FFT, discard positive frequencies
fft_dif
delete_x 0 RANGECLEN
cconjugate

# multiply in frequency domain the signal and the reversed chirp
mult

# Shift result down in frequency by fsamp/4 so chirp is centered on f=0
rotate_x -eval(RANGECLEN/2)

# Push vector telling ifft to not divide by 2 on stages indicated by $3..$7
real 1
push
real $3 $4 $5 $6 $7 
sub
pad_x 0 eval(LOG_RANGELEN-5-1)
add
xchg 1
# Go back to time domain
cconjugate
fft_dif_scale
cconjugate
end
#
#----------------------------------------------------------
# Main program

pl_open 16 0
#pl_open 16 2 lpr -g

generate_data
range_compress int16 2048 0 0 0 0 1
float32

// scale up by factor of RESAMP, then perform FFT RESAMP*interpolation
real RESAMP
float32
cvt_complex
xchg 1
mult
fft_dif
midpad_x eval(RANGECLEN/2) eval(RANGECLEN*(RESAMP-1))
ifft_dif

// Plot magnitude, and make sure our idea of where
// the peak should be is right.
push
    name (compressed,x=time)
    plot_r 0 0 2
    magnitude
    argmax_x
    name argmax_x(mag(compressed,x=time))
    real ARGMAX
    compare

// Delete everything but near the peak, and plot.
push
    edit_x eval(ARGMAX-NEAR/2) NEAR
    name re(compressed,x=time-t0-dt)
    plot_r 0 0 6

    phase
    name phase(compressed,x=time-t0-dt)
    plot_r 0 0 2
    pop

// Display the phase at the peak for all 5 echoes as a fn of echo number.
edit_x ARGMAX 1
redimension_y 1
push
    magnitude
    name mag(compressed,time=t0,x=echo#)
    plot_r 0 0 2
    pop

phase
name phase(compressed,time=t0,x=echo#)
plot_r 0 0 2
pl_close
