#ifndef arith_h
#define arith_h
/* @(#)arith.h	1.2 7/23/91 */

#if defined(__STDC__) || defined(__cplusplus)
# define _ARGS_(s) s
#else
# define _ARGS_(s) ()
#endif

/* arith.c */
void badkind _ARGS_((char *msg, int kind));
void samekind _ARGS_((char *msg, sig_t *this, sig_t *that));
void mult_cint16 _ARGS_((int n, short *ar, short *ai, short *br, short *bi));
void mult_cbfp16 _ARGS_((int n, short *ar, short *ai, int ae, short *br, short *bi, short *be));
void mult_cfloat32 _ARGS_((int n, float *ar, float *ai, float *br, float *bi));
void sig_mult _ARGS_((sig_t *this, sig_t *that));
void add_int16 _ARGS_((int n, short *a, short *b));
void add_float32 _ARGS_((int n, float *a, float *b));
void add_cbfp16 _ARGS_((int n, short *ar, short *ai, int ae, short *br, short *bi, short *be));
void sig_add _ARGS_((sig_t *this, sig_t *that));
void sub_int16 _ARGS_((int n, short *a, short *b));
void sub_float32 _ARGS_((int n, float *a, float *b));
void sub_cbfp16 _ARGS_((int n, short *ar, short *ai, int ae, short *br, short *bi, short *be));
void sig_sub _ARGS_((sig_t *this, sig_t *that));
void neg_int16 _ARGS_((int n, short *a));
void neg_float32 _ARGS_((int n, float *a));
void sig_cconjugate _ARGS_((sig_t *this));
int compare_cbfp16 _ARGS_((int n, short *ar, short *ai, int ae, short *br, short *bi, int be, int rec, int errs));
int compare_cfloat32 _ARGS_((int n, float *ar, float *ai, float *br, float *bi, int rec, int errs));
void sig_compare _ARGS_((sig_t *this, sig_t *that));
void square_float32 _ARGS_((int n, float *ar));
void square_cfloat32 _ARGS_((int n, float *ar, float *ai));
void sig_square _ARGS_((sig_t *this));
float sum_x_float32 _ARGS_((int n, float *ar));
void sig_sum_x _ARGS_((sig_t *this));
void sig_mean_x _ARGS_((sig_t *this));
float max_x_float32 _ARGS_((int n, float *ar, int *argmax));
void sig_max_x _ARGS_((sig_t *this));
void sig_argmax_x _ARGS_((sig_t *this));

#undef _ARGS_

#endif
